import _extends from "@babel/runtime/helpers/extends";

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import './DataTable-expansion-story.scss';
import { action } from '@storybook/addon-actions';
import React from 'react';
import Button from '../../../Button';
import DataTable, { Table, TableBody, TableCell, TableContainer, TableExpandHeader, TableExpandRow, TableExpandedRow, TableHead, TableHeader, TableRow, TableToolbar, TableToolbarAction, TableToolbarContent, TableToolbarSearch, TableToolbarMenu } from '../../../DataTable';
import { rows, headers } from '../shared';
import mdx from '../../DataTable.mdx';
export default {
  title: 'Components/DataTable/Expansion',
  component: DataTable,
  subcomponents: {
    TableExpandHeader: TableExpandHeader,
    TableExpandRow: TableExpandRow,
    TableExpandedRow: TableExpandedRow,
    Table: Table,
    TableBody: TableBody,
    TableCell: TableCell,
    TableContainer: TableContainer,
    TableHead: TableHead,
    TableHeader: TableHeader,
    TableRow: TableRow
  },
  parameters: {
    docs: {
      page: mdx
    }
  }
};
export var Usage = function Usage() {
  return /*#__PURE__*/React.createElement(DataTable, {
    rows: rows,
    headers: headers
  }, function (_ref) {
    var rows = _ref.rows,
        headers = _ref.headers,
        getHeaderProps = _ref.getHeaderProps,
        getRowProps = _ref.getRowProps,
        getTableProps = _ref.getTableProps,
        getTableContainerProps = _ref.getTableContainerProps;
    return /*#__PURE__*/React.createElement(TableContainer, _extends({
      title: "DataTable",
      description: "With expansion"
    }, getTableContainerProps()), /*#__PURE__*/React.createElement(Table, getTableProps(), /*#__PURE__*/React.createElement(TableHead, null, /*#__PURE__*/React.createElement(TableRow, null, /*#__PURE__*/React.createElement(TableExpandHeader, null), headers.map(function (header, i) {
      return /*#__PURE__*/React.createElement(TableHeader, _extends({
        key: i
      }, getHeaderProps({
        header: header
      })), header.header);
    }))), /*#__PURE__*/React.createElement(TableBody, null, rows.map(function (row) {
      return /*#__PURE__*/React.createElement(React.Fragment, {
        key: row.id
      }, /*#__PURE__*/React.createElement(TableExpandRow, getRowProps({
        row: row
      }), row.cells.map(function (cell) {
        return /*#__PURE__*/React.createElement(TableCell, {
          key: cell.id
        }, cell.value);
      })), /*#__PURE__*/React.createElement(TableExpandedRow, {
        colSpan: headers.length + 1,
        className: "demo-expanded-td"
      }, /*#__PURE__*/React.createElement("h6", null, "Expandable row content"), /*#__PURE__*/React.createElement("div", null, "Description here")));
    }))));
  });
};
export var ExtraSmallExpansion = function ExtraSmallExpansion() {
  return /*#__PURE__*/React.createElement(DataTable, {
    rows: rows,
    headers: headers
  }, function (_ref2) {
    var rows = _ref2.rows,
        headers = _ref2.headers,
        getHeaderProps = _ref2.getHeaderProps,
        getRowProps = _ref2.getRowProps,
        getTableProps = _ref2.getTableProps,
        onInputChange = _ref2.onInputChange,
        getToolbarProps = _ref2.getToolbarProps,
        getTableContainerProps = _ref2.getTableContainerProps;
    return /*#__PURE__*/React.createElement(TableContainer, _extends({
      title: "DataTable",
      description: "With expansion"
    }, getTableContainerProps()), /*#__PURE__*/React.createElement(TableToolbar, _extends({}, getToolbarProps(), {
      size: "xs"
    }), /*#__PURE__*/React.createElement(TableToolbarContent, null, /*#__PURE__*/React.createElement(TableToolbarSearch, {
      persistent: "true",
      onChange: onInputChange
    }), /*#__PURE__*/React.createElement(TableToolbarMenu, null, /*#__PURE__*/React.createElement(TableToolbarAction, {
      onClick: function onClick() {
        return alert('Alert 1');
      }
    }, "Action 1"), /*#__PURE__*/React.createElement(TableToolbarAction, {
      onClick: function onClick() {
        return alert('Alert 2');
      }
    }, "Action 2"), /*#__PURE__*/React.createElement(TableToolbarAction, {
      onClick: function onClick() {
        return alert('Alert 3');
      }
    }, "Action 3")), /*#__PURE__*/React.createElement(Button, {
      onClick: action('Add new row'),
      size: "small",
      kind: "primary"
    }, "Add new"))), /*#__PURE__*/React.createElement(Table, _extends({}, getTableProps(), {
      size: "compact"
    }), /*#__PURE__*/React.createElement(TableHead, null, /*#__PURE__*/React.createElement(TableRow, null, /*#__PURE__*/React.createElement(TableExpandHeader, null), headers.map(function (header, i) {
      return /*#__PURE__*/React.createElement(TableHeader, _extends({
        key: i
      }, getHeaderProps({
        header: header
      })), header.header);
    }))), /*#__PURE__*/React.createElement(TableBody, null, rows.map(function (row) {
      return /*#__PURE__*/React.createElement(React.Fragment, {
        key: row.id
      }, /*#__PURE__*/React.createElement(TableExpandRow, getRowProps({
        row: row
      }), row.cells.map(function (cell) {
        return /*#__PURE__*/React.createElement(TableCell, {
          key: cell.id
        }, cell.value);
      })), /*#__PURE__*/React.createElement(TableExpandedRow, {
        colSpan: headers.length + 1,
        className: "demo-expanded-td"
      }, /*#__PURE__*/React.createElement("h6", null, "Expandable row content"), /*#__PURE__*/React.createElement("div", null, "Description here")));
    }))));
  });
};
export var SmallExpansion = function SmallExpansion() {
  return /*#__PURE__*/React.createElement(DataTable, {
    rows: rows,
    headers: headers
  }, function (_ref3) {
    var rows = _ref3.rows,
        headers = _ref3.headers,
        getHeaderProps = _ref3.getHeaderProps,
        getRowProps = _ref3.getRowProps,
        getTableProps = _ref3.getTableProps,
        getTableContainerProps = _ref3.getTableContainerProps;
    return /*#__PURE__*/React.createElement(TableContainer, _extends({
      title: "DataTable",
      description: "With expansion"
    }, getTableContainerProps()), /*#__PURE__*/React.createElement(Table, _extends({}, getTableProps(), {
      size: "sm"
    }), /*#__PURE__*/React.createElement(TableHead, null, /*#__PURE__*/React.createElement(TableRow, null, /*#__PURE__*/React.createElement(TableExpandHeader, null), headers.map(function (header, i) {
      return /*#__PURE__*/React.createElement(TableHeader, _extends({
        key: i
      }, getHeaderProps({
        header: header
      })), header.header);
    }))), /*#__PURE__*/React.createElement(TableBody, null, rows.map(function (row) {
      return /*#__PURE__*/React.createElement(React.Fragment, {
        key: row.id
      }, /*#__PURE__*/React.createElement(TableExpandRow, getRowProps({
        row: row
      }), row.cells.map(function (cell) {
        return /*#__PURE__*/React.createElement(TableCell, {
          key: cell.id
        }, cell.value);
      })), /*#__PURE__*/React.createElement(TableExpandedRow, {
        colSpan: headers.length + 1,
        className: "demo-expanded-td"
      }, /*#__PURE__*/React.createElement("h6", null, "Expandable row content"), /*#__PURE__*/React.createElement("div", null, "Description here")));
    }))));
  });
};
export var MediumExpansion = function MediumExpansion() {
  return /*#__PURE__*/React.createElement(DataTable, {
    rows: rows,
    headers: headers
  }, function (_ref4) {
    var rows = _ref4.rows,
        headers = _ref4.headers,
        getHeaderProps = _ref4.getHeaderProps,
        getRowProps = _ref4.getRowProps,
        getTableProps = _ref4.getTableProps,
        getTableContainerProps = _ref4.getTableContainerProps;
    return /*#__PURE__*/React.createElement(TableContainer, _extends({
      title: "DataTable",
      description: "With expansion"
    }, getTableContainerProps()), /*#__PURE__*/React.createElement(Table, _extends({}, getTableProps(), {
      size: "md"
    }), /*#__PURE__*/React.createElement(TableHead, null, /*#__PURE__*/React.createElement(TableRow, null, /*#__PURE__*/React.createElement(TableExpandHeader, null), headers.map(function (header, i) {
      return /*#__PURE__*/React.createElement(TableHeader, _extends({
        key: i
      }, getHeaderProps({
        header: header
      })), header.header);
    }))), /*#__PURE__*/React.createElement(TableBody, null, rows.map(function (row) {
      return /*#__PURE__*/React.createElement(React.Fragment, {
        key: row.id
      }, /*#__PURE__*/React.createElement(TableExpandRow, getRowProps({
        row: row
      }), row.cells.map(function (cell) {
        return /*#__PURE__*/React.createElement(TableCell, {
          key: cell.id
        }, cell.value);
      })), /*#__PURE__*/React.createElement(TableExpandedRow, {
        colSpan: headers.length + 1,
        className: "demo-expanded-td"
      }, /*#__PURE__*/React.createElement("h6", null, "Expandable row content"), /*#__PURE__*/React.createElement("div", null, "Description here")));
    }))));
  });
};
export var ExtraLargeExpansion = function ExtraLargeExpansion() {
  return /*#__PURE__*/React.createElement(DataTable, {
    rows: rows,
    headers: headers
  }, function (_ref5) {
    var rows = _ref5.rows,
        headers = _ref5.headers,
        getHeaderProps = _ref5.getHeaderProps,
        getRowProps = _ref5.getRowProps,
        getTableProps = _ref5.getTableProps,
        getTableContainerProps = _ref5.getTableContainerProps;
    return /*#__PURE__*/React.createElement(TableContainer, _extends({
      title: "DataTable",
      description: "With expansion"
    }, getTableContainerProps()), /*#__PURE__*/React.createElement(Table, _extends({}, getTableProps(), {
      size: "xl"
    }), /*#__PURE__*/React.createElement(TableHead, null, /*#__PURE__*/React.createElement(TableRow, null, /*#__PURE__*/React.createElement(TableExpandHeader, null), headers.map(function (header, i) {
      return /*#__PURE__*/React.createElement(TableHeader, _extends({
        key: i
      }, getHeaderProps({
        header: header
      })), header.header);
    }))), /*#__PURE__*/React.createElement(TableBody, null, rows.map(function (row) {
      return /*#__PURE__*/React.createElement(React.Fragment, {
        key: row.id
      }, /*#__PURE__*/React.createElement(TableExpandRow, getRowProps({
        row: row
      }), row.cells.map(function (cell) {
        return /*#__PURE__*/React.createElement(TableCell, {
          key: cell.id
        }, cell.value);
      })), /*#__PURE__*/React.createElement(TableExpandedRow, {
        colSpan: headers.length + 1,
        className: "demo-expanded-td"
      }, /*#__PURE__*/React.createElement("h6", null, "Expandable row content"), /*#__PURE__*/React.createElement("div", null, "Description here")));
    }))));
  });
};
export var BatchExpansion = function BatchExpansion() {
  return /*#__PURE__*/React.createElement(DataTable, {
    rows: rows,
    headers: headers,
    render: function render(_ref6) {
      var rows = _ref6.rows,
          headers = _ref6.headers,
          getHeaderProps = _ref6.getHeaderProps,
          getExpandHeaderProps = _ref6.getExpandHeaderProps,
          getRowProps = _ref6.getRowProps,
          getTableProps = _ref6.getTableProps,
          getTableContainerProps = _ref6.getTableContainerProps;
      return /*#__PURE__*/React.createElement(TableContainer, _extends({
        title: "DataTable",
        description: "With batch expansion"
      }, getTableContainerProps()), /*#__PURE__*/React.createElement(Table, getTableProps(), /*#__PURE__*/React.createElement(TableHead, null, /*#__PURE__*/React.createElement(TableRow, null, /*#__PURE__*/React.createElement(TableExpandHeader, _extends({
        enableExpando: true
      }, getExpandHeaderProps())), headers.map(function (header, i) {
        return /*#__PURE__*/React.createElement(TableHeader, _extends({
          key: i
        }, getHeaderProps({
          header: header
        })), header.header);
      }))), /*#__PURE__*/React.createElement(TableBody, null, rows.map(function (row) {
        return /*#__PURE__*/React.createElement(React.Fragment, {
          key: row.id
        }, /*#__PURE__*/React.createElement(TableExpandRow, getRowProps({
          row: row
        }), row.cells.map(function (cell) {
          return /*#__PURE__*/React.createElement(TableCell, {
            key: cell.id
          }, cell.value);
        })), /*#__PURE__*/React.createElement(TableExpandedRow, {
          colSpan: headers.length + 1,
          className: "demo-expanded-td"
        }, /*#__PURE__*/React.createElement("h6", null, "Expandable row content"), /*#__PURE__*/React.createElement("div", null, "Description here")));
      }))));
    }
  });
};