import _slicedToArray from "@babel/runtime/helpers/slicedToArray";

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { useState } from 'react';

function useDisclosure(id) {
  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      open = _useState2[0],
      setOpen = _useState2[1];

  var buttonProps = {
    'aria-controls': id,
    'aria-expanded': open,
    onClick: function onClick() {
      setOpen(!open);
    }
  };
  var contentProps = {
    id: id
  };
  return {
    buttonProps: buttonProps,
    contentProps: contentProps,
    open: open
  };
}

export { useDisclosure };