/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import 'carbon-components/scss/components/dropdown/_dropdown.scss';
import React from 'react';
import { mount } from '@cypress/react';
import { generateItems, generateGenericItem } from '../ListBox/test-helpers';
import Dropdown from '../Dropdown';
import DropdownSkeleton from '../Dropdown/Dropdown.Skeleton';
describe('Dropdown', function () {
  beforeEach(function () {
    var items = generateItems(5, generateGenericItem);
    var label = 'Dropdown menu options';
    var style = {
      marginBottom: '1rem'
    };
    mount( /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Dropdown, {
      style: {
        marginBottom: '14rem'
      },
      items: items,
      label: label
    }), /*#__PURE__*/React.createElement(Dropdown, {
      style: style,
      items: items,
      label: label,
      size: "sm"
    }), /*#__PURE__*/React.createElement(Dropdown, {
      style: style,
      items: items,
      label: label,
      size: "md"
    }), /*#__PURE__*/React.createElement(Dropdown, {
      style: style,
      items: items,
      label: label,
      size: "lg"
    }), /*#__PURE__*/React.createElement(Dropdown, {
      style: style,
      items: items,
      label: label,
      size: "xl"
    }), /*#__PURE__*/React.createElement(Dropdown, {
      style: style,
      items: items,
      label: label,
      disabled: true
    }), /*#__PURE__*/React.createElement(Dropdown, {
      style: style,
      items: items,
      label: label,
      helperText: "This is helper text"
    }), /*#__PURE__*/React.createElement(Dropdown, {
      style: style,
      items: items,
      label: label,
      warn: true
    }), /*#__PURE__*/React.createElement(Dropdown, {
      style: style,
      items: items,
      label: label,
      warn: true,
      warnText: "This is warn text"
    }), /*#__PURE__*/React.createElement(Dropdown, {
      style: style,
      items: items,
      label: label,
      invalid: true,
      invalidText: "This is invalid text"
    }), /*#__PURE__*/React.createElement(Dropdown, {
      style: style,
      items: items,
      label: label,
      light: true
    }), /*#__PURE__*/React.createElement(Dropdown, {
      style: style,
      items: items,
      label: label,
      light: true,
      invalid: true,
      invalidText: "This is invalid text"
    }), /*#__PURE__*/React.createElement(Dropdown, {
      style: style,
      items: items,
      label: label,
      type: "inline"
    }), /*#__PURE__*/React.createElement(DropdownSkeleton, {
      style: style,
      size: "sm"
    }), /*#__PURE__*/React.createElement(DropdownSkeleton, {
      style: style,
      size: "md"
    }), /*#__PURE__*/React.createElement(DropdownSkeleton, {
      style: style,
      size: "lg"
    }), /*#__PURE__*/React.createElement(DropdownSkeleton, {
      style: style,
      size: "xl"
    })));
  });
  it('should render', function () {
    cy.findAllByText(/Dropdown menu options/).should('have.length', 13).last().should('be.visible'); // snapshots should always be taken _after_ an assertion that
    // a element/component should be visible. This is to ensure
    // the DOM has settled and the element has fully loaded.

    cy.percySnapshot();
  });
  it('should render listbox when clicked', function () {
    cy.findAllByText(/Dropdown menu options/).first().click();
    cy.findAllByText(/Item 0/).first().should('be.visible');
    cy.findAllByText(/Item 4/).first().should('be.visible'); // snapshots should always be taken _after_ an assertion that
    // a element/component should be visible. This is to ensure
    // the DOM has settled and the element has fully loaded.

    cy.percySnapshot();
  });
});