/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { default as Dropdown, DropdownSkeleton } from '../';
import { Layer } from '../../Layer';
var items = [{
  id: 'option-0',
  text: 'Lorem, ipsum dolor sit amet consectetur adipisicing elit.'
}, {
  id: 'option-1',
  text: 'Option 1'
}, {
  id: 'option-2',
  text: 'Option 2'
}, {
  id: 'option-3',
  text: 'Option 3 - a disabled item',
  disabled: true
}, {
  id: 'option-4',
  text: 'Option 4'
}, {
  id: 'option-5',
  text: 'Option 5'
}];
export default {
  title: 'Components/Dropdown',
  parameters: {
    component: Dropdown,
    subcomponents: {
      DropdownSkeleton: DropdownSkeleton
    }
  }
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: 400
    }
  }, /*#__PURE__*/React.createElement(Dropdown, {
    id: "default",
    titleText: "Dropdown label",
    helperText: "This is some helper text",
    label: "Dropdown menu options",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    }
  }));
};
export var Inline = function Inline() {
  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: 600
    }
  }, /*#__PURE__*/React.createElement(Dropdown, {
    id: "inline",
    titleText: "Inline dropdown label",
    label: "Dropdown menu options",
    type: "inline",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    }
  }));
};
export var withLayer = function withLayer() {
  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: 400
    }
  }, /*#__PURE__*/React.createElement(Dropdown, {
    id: "default",
    titleText: "First Layer",
    helperText: "This is some helper text",
    label: "Dropdown menu options",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    }
  }), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(Dropdown, {
    id: "default",
    titleText: "Second Layer",
    helperText: "This is some helper text",
    label: "Dropdown menu options",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    }
  }), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(Dropdown, {
    id: "default",
    titleText: "Third Layer",
    helperText: "This is some helper text",
    label: "Dropdown menu options",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    }
  }))));
};
export var InlineWithLayer = function InlineWithLayer() {
  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: 600
    }
  }, /*#__PURE__*/React.createElement(Dropdown, {
    id: "inline",
    titleText: "First Layer",
    label: "Dropdown menu options",
    type: "inline",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    }
  }), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(Dropdown, {
    id: "inline",
    titleText: "Second Layer",
    label: "Dropdown menu options",
    type: "inline",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    }
  }), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(Dropdown, {
    id: "inline",
    titleText: "Third Layer",
    label: "Dropdown menu options",
    type: "inline",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    }
  }))));
};
export var Skeleton = function Skeleton() {
  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/React.createElement(DropdownSkeleton, null));
};