import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";

/**
 * Copyright IBM Corp. 2021
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useState, useRef, useEffect } from 'react';
import classnames from 'classnames';
import { settings } from 'carbon-components';
import Search from '../Search';
var prefix = settings.prefix;

function ExpandableSearch(props) {
  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      expanded = _useState2[0],
      setExpanded = _useState2[1];

  var searchRef = useRef(null);

  function handleFocus() {
    if (!expanded) {
      setExpanded(true);
    }
  }

  function handleBlur(evt) {
    var relatedTargetIsAllowed = evt.relatedTarget && evt.relatedTarget.classList.contains("".concat(prefix, "--search-close"));

    if (expanded && !relatedTargetIsAllowed && !searchRef.current.state.hasContent) {
      setExpanded(false);
    }
  }

  useEffect(function () {
    var _searchRef$current2;

    function focusInput() {
      var _searchRef$current;

      if (!expanded && (_searchRef$current = searchRef.current) !== null && _searchRef$current !== void 0 && _searchRef$current.input) {
        searchRef.current.input.focus();
      }
    }

    if ((_searchRef$current2 = searchRef.current) !== null && _searchRef$current2 !== void 0 && _searchRef$current2.magnifier) {
      var magnifier = searchRef.current.magnifier;
      magnifier.addEventListener('click', focusInput);
      return function () {
        magnifier.removeEventListener('click', focusInput);
      };
    }
  }, [expanded, searchRef]);
  var classes = classnames("".concat(prefix, "--search--expandable"), _defineProperty({}, "".concat(prefix, "--search--expanded"), expanded), props.className);
  return /*#__PURE__*/React.createElement(Search, _extends({}, props, {
    ref: searchRef,
    className: classes,
    onFocus: handleFocus,
    onBlur: handleBlur
  }));
}

ExpandableSearch.propTypes = Search.propTypes;
export default ExpandableSearch;