import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["iconDescription", "buttonLabel", "buttonKind", "filenameStatus", "labelDescription", "labelTitle", "className", "multiple", "accept", "name", "size", "onDelete"];

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import classNames from 'classnames';
import PropTypes from 'prop-types';
import * as FeatureFlags from '@carbon/feature-flags';
import React from 'react';
import Filename from './Filename';
import FileUploaderButton from './FileUploaderButton';
import { ButtonKinds } from '../../prop-types/types';
import { keys, matches } from '../../internal/keyboard';
import { PrefixContext } from '../../internal/usePrefix';

var FileUploader = /*#__PURE__*/function (_React$Component) {
  _inherits(FileUploader, _React$Component);

  var _super = _createSuper(FileUploader);

  function FileUploader() {
    var _this;

    _classCallCheck(this, FileUploader);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      filenames: []
    });

    _defineProperty(_assertThisInitialized(_this), "nodes", []);

    _defineProperty(_assertThisInitialized(_this), "handleChange", function (evt) {
      evt.stopPropagation();
      var filenames = Array.prototype.map.call(evt.target.files, function (file) {
        return file.name;
      });

      _this.setState({
        filenames: _this.props.multiple ? _this.state.filenames.concat(filenames) : filenames
      });

      if (_this.props.onChange) {
        _this.props.onChange(evt);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "handleClick", function (evt, _ref) {
      var index = _ref.index,
          filenameStatus = _ref.filenameStatus;

      if (filenameStatus === 'edit') {
        evt.stopPropagation();

        var filteredArray = _this.state.filenames.filter(function (filename) {
          return filename !== _this.nodes[index].innerText.trim();
        });

        _this.setState({
          filenames: filteredArray
        });

        if (_this.props.onDelete) {
          _this.props.onDelete(evt);
        }

        _this.props.onClick(evt);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "clearFiles", function () {
      // A clearFiles function that resets filenames and can be referenced using a ref by the parent.
      _this.setState({
        filenames: []
      });
    });

    return _this;
  }

  _createClass(FileUploader, [{
    key: "render",
    value: function render() {
      var _classNames,
          _classNames2,
          _this2 = this;

      var _this$props = this.props,
          iconDescription = _this$props.iconDescription,
          buttonLabel = _this$props.buttonLabel,
          buttonKind = _this$props.buttonKind,
          filenameStatus = _this$props.filenameStatus,
          labelDescription = _this$props.labelDescription,
          labelTitle = _this$props.labelTitle,
          className = _this$props.className,
          multiple = _this$props.multiple,
          accept = _this$props.accept,
          name = _this$props.name,
          size = _this$props.size,
          onDelete = _this$props.onDelete,
          other = _objectWithoutProperties(_this$props, _excluded);

      var prefix = this.context;
      var classes = classNames((_classNames = {}, _defineProperty(_classNames, "".concat(prefix, "--form-item"), true), _defineProperty(_classNames, className, className), _classNames));
      var selectedFileClasses = classNames("".concat(prefix, "--file__selected-file"), (_classNames2 = {}, _defineProperty(_classNames2, "".concat(prefix, "--file__selected-file--md"), size === 'field' || size === 'md'), _defineProperty(_classNames2, "".concat(prefix, "--file__selected-file--sm"), size === 'small' || size === 'sm'), _classNames2));
      return /*#__PURE__*/React.createElement("div", _extends({
        className: classes
      }, other), FeatureFlags.enabled('enable-v11-release') && !labelTitle ? null : /*#__PURE__*/React.createElement("p", {
        className: "".concat(prefix, "--file--label")
      }, labelTitle), /*#__PURE__*/React.createElement("p", {
        className: "".concat(prefix, "--label-description")
      }, labelDescription), /*#__PURE__*/React.createElement(FileUploaderButton, {
        labelText: buttonLabel,
        multiple: multiple,
        buttonKind: buttonKind,
        onChange: this.handleChange,
        disableLabelChanges: true,
        accept: accept,
        name: name,
        size: size
      }), /*#__PURE__*/React.createElement("div", {
        className: "".concat(prefix, "--file-container")
      }, this.state.filenames.length === 0 ? null : this.state.filenames.map(function (name, index) {
        return /*#__PURE__*/React.createElement("span", _extends({
          key: index,
          className: selectedFileClasses,
          ref: function ref(node) {
            return _this2.nodes[index] = node;
          } // eslint-disable-line

        }, other), /*#__PURE__*/React.createElement("p", {
          className: "".concat(prefix, "--file-filename")
        }, name), /*#__PURE__*/React.createElement("span", {
          className: "".concat(prefix, "--file__state-container")
        }, /*#__PURE__*/React.createElement(Filename, {
          iconDescription: iconDescription,
          status: filenameStatus,
          onKeyDown: function onKeyDown(evt) {
            if (matches(evt, [keys.Enter, keys.Space])) {
              _this2.handleClick(evt, {
                index: index,
                filenameStatus: filenameStatus
              });
            }
          },
          onClick: function onClick(evt) {
            return _this2.handleClick(evt, {
              index: index,
              filenameStatus: filenameStatus
            });
          }
        })));
      })));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(_ref2, state) {
      var filenameStatus = _ref2.filenameStatus;
      var prevFilenameStatus = state.prevFilenameStatus;
      return prevFilenameStatus === filenameStatus ? null : {
        filenameStatus: filenameStatus,
        prevFilenameStatus: filenameStatus
      };
    }
  }]);

  return FileUploader;
}(React.Component);

_defineProperty(FileUploader, "propTypes", {
  /**
   * Specify the types of files that this input should be able to receive
   */
  accept: PropTypes.arrayOf(PropTypes.string),

  /**
   * Specify the type of the <FileUploaderButton>
   */
  buttonKind: PropTypes.oneOf(ButtonKinds),

  /**
   * Provide the label text to be read by screen readers when interacting with
   * the <FileUploaderButton>
   */
  buttonLabel: PropTypes.string,

  /**
   * Provide a custom className to be applied to the container node
   */
  className: PropTypes.string,

  /**
   * Specify the status of the File Upload
   */
  filenameStatus: PropTypes.oneOf(['edit', 'complete', 'uploading']).isRequired,

  /**
   * Provide a description for the complete/close icon that can be read by screen readers
   */
  iconDescription: FeatureFlags.enabled('enable-v11-release') ? PropTypes.string.isRequired : PropTypes.string,

  /**
   * Specify the description text of this <FileUploader>
   */
  labelDescription: PropTypes.string,

  /**
   * Specify the title text of this <FileUploader>
   */
  labelTitle: PropTypes.string,

  /**
   * Specify if the component should accept multiple files to upload
   */
  multiple: PropTypes.bool,

  /**
   * Provide a name for the underlying `<input>` node
   */
  name: PropTypes.string,

  /**
   * Provide an optional `onChange` hook that is called each time the input is
   * changed
   */
  onChange: PropTypes.func,

  /**
   * Provide an optional `onClick` hook that is called each time the
   * FileUploader is clicked
   */
  onClick: PropTypes.func,

  /**
   * Provide an optional `onDelete` hook that is called when an uploaded item
   * is removed
   */
  onDelete: PropTypes.func,

  /**
   * Specify the size of the FileUploaderButton, from a list of available
   * sizes. For `default` buttons, this prop can remain unspecified.
   * V11: `default`, `field`, and `small` will be removed
   */
  size: PropTypes.oneOf(['default', 'field', 'small', 'sm', 'md', 'lg'])
});

_defineProperty(FileUploader, "contextType", PrefixContext);

_defineProperty(FileUploader, "defaultProps", {
  iconDescription: FeatureFlags.enabled('enable-v11-release') ? undefined : 'Provide icon description',
  filenameStatus: 'uploading',
  buttonLabel: '',
  buttonKind: 'primary',
  multiple: false,
  onClick: function onClick() {},
  accept: []
});

export { FileUploader as default };