import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["accept", "buttonKind", "className", "disabled", "disableLabelChanges", "id", "labelText", "multiple", "onChange", "role", "name", "size", "tabIndex"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import cx from 'classnames';
import PropTypes from 'prop-types';
import React, { useRef, useState } from 'react';
import { matches, keys } from '../../internal/keyboard';
import { ButtonKinds } from '../../prop-types/types';
import uid from '../../tools/uniqueId';
import { usePrefix } from '../../internal/usePrefix';

function noop() {}

function FileUploaderButton(_ref) {
  var _cx;

  var accept = _ref.accept,
      _ref$buttonKind = _ref.buttonKind,
      buttonKind = _ref$buttonKind === void 0 ? 'primary' : _ref$buttonKind,
      className = _ref.className,
      _ref$disabled = _ref.disabled,
      disabled = _ref$disabled === void 0 ? false : _ref$disabled,
      _ref$disableLabelChan = _ref.disableLabelChanges,
      disableLabelChanges = _ref$disableLabelChan === void 0 ? false : _ref$disableLabelChan,
      id = _ref.id,
      _ref$labelText = _ref.labelText,
      ownerLabelText = _ref$labelText === void 0 ? 'Add file' : _ref$labelText,
      _ref$multiple = _ref.multiple,
      multiple = _ref$multiple === void 0 ? false : _ref$multiple,
      _ref$onChange = _ref.onChange,
      onChange = _ref$onChange === void 0 ? noop : _ref$onChange,
      _ref$role = _ref.role,
      role = _ref$role === void 0 ? 'button' : _ref$role,
      name = _ref.name,
      size = _ref.size,
      _ref$tabIndex = _ref.tabIndex,
      tabIndex = _ref$tabIndex === void 0 ? 0 : _ref$tabIndex,
      other = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();

  var _useState = useState(ownerLabelText),
      _useState2 = _slicedToArray(_useState, 2),
      labelText = _useState2[0],
      setLabelText = _useState2[1];

  var _useState3 = useState(ownerLabelText),
      _useState4 = _slicedToArray(_useState3, 2),
      prevOwnerLabelText = _useState4[0],
      setPrevOwnerLabelText = _useState4[1];

  var _useRef = useRef(id || uid()),
      inputId = _useRef.current;

  var inputNode = useRef(null);
  var classes = cx("".concat(prefix, "--btn"), className, (_cx = {}, _defineProperty(_cx, "".concat(prefix, "--btn--").concat(buttonKind), buttonKind), _defineProperty(_cx, "".concat(prefix, "--btn--disabled"), disabled), _defineProperty(_cx, "".concat(prefix, "--btn--md"), size === 'field' || size === 'md'), _defineProperty(_cx, "".concat(prefix, "--btn--sm"), size === 'small' || size === 'sm'), _cx)); // Adjust label text state based on changes to the labelText prop

  if (ownerLabelText !== prevOwnerLabelText) {
    setLabelText(ownerLabelText);
    setPrevOwnerLabelText(ownerLabelText);
  }

  function onClick(event) {
    event.target.value = null;
  }

  function onKeyDown(event) {
    if (matches(event, [keys.Enter, keys.Space])) {
      inputNode.current.click();
    }
  }

  function handleOnChange(event) {
    var files = event.target.files;
    var length = event.target.files.length;

    if (files && !disableLabelChanges) {
      if (length > 1) {
        setLabelText("".concat(length, " files"));
      } else if (length === 1) {
        setLabelText(files[0].name);
      }
    }

    onChange(event);
  }

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("label", _extends({
    tabIndex: disabled ? -1 : tabIndex || 0,
    className: classes,
    onKeyDown: onKeyDown,
    htmlFor: inputId
  }, other), /*#__PURE__*/React.createElement("span", {
    role: role,
    "aria-disabled": disabled
  }, labelText)), /*#__PURE__*/React.createElement("input", {
    className: "".concat(prefix, "--visually-hidden"),
    ref: inputNode,
    id: inputId,
    disabled: disabled,
    type: "file",
    tabIndex: "-1",
    multiple: multiple,
    accept: accept,
    name: name,
    onChange: handleOnChange,
    onClick: onClick
  }));
}

FileUploaderButton.propTypes = {
  /**
   * Specify the types of files that this input should be able to receive
   */
  accept: PropTypes.arrayOf(PropTypes.string),

  /**
   * Specify the type of underlying button
   */
  buttonKind: PropTypes.oneOf(ButtonKinds),

  /**
   * Provide a custom className to be applied to the container node
   */
  className: PropTypes.string,

  /**
   * Specify whether you want to disable any updates to the FileUploaderButton
   * label
   */
  disableLabelChanges: PropTypes.bool,

  /**
   * Specify whether file input is disabled
   */
  disabled: PropTypes.bool,

  /**
   * Provide a unique id for the underlying <input> node
   */
  id: PropTypes.string,

  /**
   * Provide the label text to be read by screen readers when interacting with
   * this control
   */
  labelText: PropTypes.node,

  /**
   * Specify if the component should accept multiple files to upload
   */
  multiple: PropTypes.bool,

  /**
   * Provide a name for the underlying <input> node
   */
  name: PropTypes.string,

  /**
   * Provide an optional `onChange` hook that is called each time the <input>
   * value changes
   */
  onChange: PropTypes.func,

  /**
   * Provide an optional `onClick` hook that is called each time the button is
   * clicked
   */
  onClick: PropTypes.func,

  /**
   * Provide an accessibility role for the <FileUploaderButton>
   */
  role: PropTypes.string,

  /**
   * Specify the size of the FileUploaderButton, from a list of available
   * sizes. For `default` buttons, this prop can remain unspecified.
   * V11: `default`, `field`, and `small` will be removed
   */
  size: PropTypes.oneOf(['default', 'field', 'small', 'sm', 'md', 'lg']),

  /**
   * Provide a custom tabIndex value for the <FileUploaderButton>
   */
  tabIndex: PropTypes.number
};
export default FileUploaderButton;