import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["iconDescription", "status", "invalid"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { Close16, WarningFilled16, CheckmarkFilled16 } from '@carbon/icons-react';
import { settings } from 'carbon-components';
import PropTypes from 'prop-types';
import React from 'react';
import Loading from '../Loading';
var prefix = settings.prefix;

function Filename(_ref) {
  var iconDescription = _ref.iconDescription,
      status = _ref.status,
      invalid = _ref.invalid,
      rest = _objectWithoutProperties(_ref, _excluded);

  switch (status) {
    case 'uploading':
      return /*#__PURE__*/React.createElement(Loading, {
        description: iconDescription,
        small: true,
        withOverlay: false
      });

    case 'edit':
      return /*#__PURE__*/React.createElement(React.Fragment, null, invalid && /*#__PURE__*/React.createElement(WarningFilled16, {
        className: "".concat(prefix, "--file-invalid")
      }), /*#__PURE__*/React.createElement("button", _extends({
        "aria-label": iconDescription,
        className: "".concat(prefix, "--file-close"),
        type: "button"
      }, rest), /*#__PURE__*/React.createElement(Close16, null)));

    case 'complete':
      return /*#__PURE__*/React.createElement(CheckmarkFilled16, _extends({
        "aria-label": iconDescription,
        className: "".concat(prefix, "--file-complete")
      }, rest), iconDescription && /*#__PURE__*/React.createElement("title", null, iconDescription));

    default:
      return null;
  }
}

Filename.propTypes = {
  /**
   * Provide a description of the SVG icon to denote file upload status
   */
  iconDescription: PropTypes.string,

  /**
   * Specify if the file is invalid
   */
  invalid: PropTypes.bool,

  /**
   * Status of the file upload
   */
  status: PropTypes.oneOf(['edit', 'complete', 'uploading']),

  /**
   * Provide a custom tabIndex value for the <Filename>
   */
  tabIndex: PropTypes.string
};
Filename.defaultProps = {
  iconDescription: 'Uploading file',
  status: 'uploading',
  tabIndex: '0'
};
export default Filename;