import _extends from "@babel/runtime/helpers/extends";

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { action } from '@storybook/addon-actions';
import { withKnobs } from '@storybook/addon-knobs';
import FluidForm from '../FluidForm';
import TextInput from '../TextInput';
var additionalProps = {
  className: 'some-class',
  onSubmit: function onSubmit(e) {
    e.preventDefault();
    action('FormSubmitted')(e);
  }
};
var TextInputProps = {
  className: 'some-class',
  id: 'test2',
  labelText: 'Text Input label',
  placeholder: 'Placeholder text'
};
var InvalidPasswordProps = {
  className: 'some-class',
  id: 'test4',
  labelText: 'Password',
  invalid: true,
  invalidText: 'Your password must be at least 6 characters as well as contain at least one uppercase, one lowercase, and one number.'
};
export default {
  title: 'Experimental/FluidForm',
  decorators: [withKnobs],
  parameters: {
    component: FluidForm
  }
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(FluidForm, additionalProps, /*#__PURE__*/React.createElement(TextInput, TextInputProps), /*#__PURE__*/React.createElement(TextInput, _extends({
    type: "password",
    required: true,
    pattern: "(?=.*\\d)(?=.*[a-z])(?=.*[A-Z]).{6,}"
  }, InvalidPasswordProps)));
};
Default.parameters = {
  info: {
    text: "\n        Forms are widely used to collect user input.\n\n        Form can have any number of react components enclosed within FormGroup component. FormGroup component\n        is a wrapper for legend and fieldset component.\n\n      "
  }
};