import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["as", "condensed", "narrow", "fullWidth", "columns", "className", "children"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import cx from 'classnames';
import PropTypes from 'prop-types';
import React, { useContext } from 'react';
import { useFeatureFlag } from '../FeatureFlags';
import { usePrefix } from '../../internal/usePrefix';
var SubgridContext = /*#__PURE__*/React.createContext(false);

function Grid(_ref) {
  var _cssGridClassNames, _flexGridClassNames;

  var _ref$as = _ref.as,
      BaseComponent = _ref$as === void 0 ? 'div' : _ref$as,
      _ref$condensed = _ref.condensed,
      condensed = _ref$condensed === void 0 ? false : _ref$condensed,
      _ref$narrow = _ref.narrow,
      narrow = _ref$narrow === void 0 ? false : _ref$narrow,
      _ref$fullWidth = _ref.fullWidth,
      fullWidth = _ref$fullWidth === void 0 ? false : _ref$fullWidth,
      _ref$columns = _ref.columns,
      columns = _ref$columns === void 0 ? 16 : _ref$columns,
      containerClassName = _ref.className,
      children = _ref.children,
      rest = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  var hasCSSGrid = useFeatureFlag('enable-css-grid');
  var isSubgrid = useContext(SubgridContext);
  var cssGridClassNames = (_cssGridClassNames = {}, _defineProperty(_cssGridClassNames, "".concat(prefix, "--css-grid"), !isSubgrid), _defineProperty(_cssGridClassNames, "".concat(prefix, "--css-grid--").concat(columns), !isSubgrid && columns !== 16), _defineProperty(_cssGridClassNames, "".concat(prefix, "--css-grid--condensed"), condensed), _defineProperty(_cssGridClassNames, "".concat(prefix, "--css-grid--narrow"), narrow), _defineProperty(_cssGridClassNames, "".concat(prefix, "--css-grid--full-width"), fullWidth), _defineProperty(_cssGridClassNames, "".concat(prefix, "--subgrid"), isSubgrid), _defineProperty(_cssGridClassNames, "".concat(prefix, "--col-span-").concat(columns), isSubgrid && columns !== 16 || columns !== 16), _cssGridClassNames);
  var flexGridClassNames = (_flexGridClassNames = {}, _defineProperty(_flexGridClassNames, "".concat(prefix, "--grid"), true), _defineProperty(_flexGridClassNames, "".concat(prefix, "--grid--condensed"), condensed), _defineProperty(_flexGridClassNames, "".concat(prefix, "--grid--narrow"), narrow), _defineProperty(_flexGridClassNames, "".concat(prefix, "--grid--full-width"), fullWidth), _flexGridClassNames);
  var className = cx(containerClassName, hasCSSGrid ? cssGridClassNames : flexGridClassNames);
  return /*#__PURE__*/React.createElement(SubgridContext.Provider, {
    value: true
  }, /*#__PURE__*/React.createElement(BaseComponent, _extends({
    className: className
  }, rest), children));
}

Grid.propTypes = {
  /**
   * Provide a custom element to render instead of the default <div>
   */
  as: PropTypes.oneOfType([PropTypes.string, PropTypes.elementType]),

  /**
   * Pass in content that will be rendered within the `Grid`
   */
  children: PropTypes.node,

  /**
   * Specify a custom className to be applied to the `Grid`
   */
  className: PropTypes.string,

  /**
   * Specify how many columns wide the Grid should span
   */
  columns: PropTypes.number,

  /**
   * Collapse the gutter to 1px. Useful for fluid layouts.
   * Rows have 1px of margin between them to match gutter.
   */
  condensed: PropTypes.bool,

  /**
   * Remove the default max width that the grid has set
   */
  fullWidth: PropTypes.bool,

  /**
   * Container hangs 16px into the gutter. Useful for
   * typographic alignment with and without containers.
   */
  narrow: PropTypes.bool
};
export default Grid;