import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["as", "children"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
var HeadingContext = /*#__PURE__*/React.createContext(1);

function Section(_ref) {
  var _ref$as = _ref.as,
      BaseComponent = _ref$as === void 0 ? 'section' : _ref$as,
      children = _ref.children,
      rest = _objectWithoutProperties(_ref, _excluded);

  var level = React.useContext(HeadingContext);
  return /*#__PURE__*/React.createElement(HeadingContext.Provider, {
    value: Math.min(level + 1, 6)
  }, /*#__PURE__*/React.createElement(BaseComponent, rest, children));
}

Section.propTypes = {
  /**
   * Provide an alternative tag or component to use instead of the default
   * <section> element
   */
  as: PropTypes.elementType,

  /**
   * Specify the content that will be placed in the component
   */
  children: PropTypes.node,

  /**
   * Specify a class name for the outermost node of the component
   */
  className: PropTypes.string
};

function Heading(props) {
  var level = React.useContext(HeadingContext);
  return /*#__PURE__*/React.createElement("h".concat(level), props);
}

Heading.propTypes = {
  /**
   * Specify the content that will be placed in the component
   */
  children: PropTypes.node,

  /**
   * Specify a class name for the outermost node of the component
   */
  className: PropTypes.string
};
export { Section, Heading };