/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { render, screen } from '@testing-library/react';
import InlineCheckbox from '../InlineCheckbox';
import userEvent from '@testing-library/user-event';
describe('InlineCheckbox', function () {
  it('should render', function () {
    render( /*#__PURE__*/React.createElement(InlineCheckbox, null));
    expect(screen.getByRole('checkbox')).toBeInTheDocument();
  });
  it('should only propagate click events from the input', function () {
    var onClick = jest.fn();
    render(
    /*#__PURE__*/

    /* eslint-disable jsx-a11y/click-events-have-key-events,jsx-a11y/no-static-element-interactions */
    React.createElement("div", {
      onClick: onClick
    }, /*#__PURE__*/React.createElement(InlineCheckbox, null)));
    userEvent.click(screen.getByRole('checkbox'));
    expect(onClick).toHaveBeenCalledTimes(1);
  });
});