import _extends from "@babel/runtime/helpers/extends";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import { settings } from 'carbon-components';
import mergeRefs from '../../tools/mergeRefs';
var prefix = settings.prefix;

var InlineCheckbox = /*#__PURE__*/function (_React$Component) {
  _inherits(InlineCheckbox, _React$Component);

  var _super = _createSuper(InlineCheckbox);

  function InlineCheckbox() {
    var _this;

    _classCallCheck(this, InlineCheckbox);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "handleRef", function (el) {
      _this.inputNode = el;
    });

    return _this;
  }

  _createClass(InlineCheckbox, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.inputNode) {
        this.inputNode.indeterminate = this.props.indeterminate;
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (this.inputNode && prevProps.indeterminate !== this.props.indeterminate) {
        this.inputNode.indeterminate = this.props.indeterminate;
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          id = _this$props.id,
          indeterminate = _this$props.indeterminate,
          checked = _this$props.checked,
          disabled = _this$props.disabled,
          ariaLabel = _this$props.ariaLabel,
          name = _this$props.name,
          _onChange = _this$props.onChange,
          onClick = _this$props.onClick,
          onKeyDown = _this$props.onKeyDown,
          _this$props$title = _this$props.title,
          title = _this$props$title === void 0 ? undefined : _this$props$title,
          ref = _this$props.innerRef;
      var inputProps = {
        id: id,
        name: name,
        onClick: onClick,
        onChange: function onChange(evt) {
          _onChange(evt.target.checked, id, evt);
        },
        onKeyDown: onKeyDown,
        className: "".concat(prefix, "--checkbox"),
        type: 'checkbox',
        ref: mergeRefs(ref, this.handleRef),
        checked: false,
        disabled: disabled
      };

      if (checked) {
        inputProps.checked = true;
      }

      if (indeterminate) {
        inputProps.checked = false;
        inputProps['aria-checked'] = 'mixed';
      }

      return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("input", inputProps),
      /*#__PURE__*/

      /* eslint-disable jsx-a11y/label-has-for,jsx-a11y/label-has-associated-control,jsx-a11y/click-events-have-key-events,jsx-a11y/no-noninteractive-element-interactions */
      React.createElement("label", {
        htmlFor: id,
        className: "".concat(prefix, "--checkbox-label"),
        "aria-label": ariaLabel,
        title: title,
        onClick: function onClick(evt) {
          evt.stopPropagation();
        }
      }));
    }
  }]);

  return InlineCheckbox;
}(React.Component);

_defineProperty(InlineCheckbox, "propTypes", {
  /**
   * Specify the label for the control
   */
  ariaLabel: PropTypes.string.isRequired,

  /**
   * Specify whether the underlying control is checked, or not
   */
  checked: PropTypes.bool.isRequired,

  /**
   * Specify whether the underlying input control should be disabled
   */
  disabled: PropTypes.bool,

  /**
   * Provide an `id` for the underlying input control
   */
  id: PropTypes.string.isRequired,

  /**
   * Specify whether the control is in an indterminate state
   */
  indeterminate: PropTypes.bool,

  /**
   * Provide a `name` for the underlying input control
   */
  name: PropTypes.string.isRequired,

  /**
   * Provide an optional hook that is called each time the input is updated
   */
  onChange: PropTypes.func,

  /**
   * Provide a handler that is invoked when a user clicks on the control
   */
  onClick: PropTypes.func,

  /**
   * Provide a handler that is invoked on the key down event for the control
   */
  onKeyDown: PropTypes.func,

  /**
   * Provide an optional tooltip for the InlineCheckbox
   */
  title: PropTypes.string
});

_defineProperty(InlineCheckbox, "defaultProps", {
  ariaLabel: '',
  checked: false,
  id: 'inline-checkbox',
  name: '',
  onChange: function onChange() {}
});

export default (function () {
  var forwardRef = function forwardRef(props, ref) {
    return /*#__PURE__*/React.createElement(InlineCheckbox, _extends({}, props, {
      innerRef: ref
    }));
  };

  forwardRef.displayName = 'InlineCheckbox';
  return /*#__PURE__*/React.forwardRef(forwardRef);
})();