/**
 * Copyright IBM Corp. 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import PropTypes from 'prop-types';
import MenuGroup from './MenuGroup';
import MenuRadioGroupOptions from './MenuRadioGroupOptions';

function MenuRadioGroup(_ref) {
  var items = _ref.items,
      initialSelectedItem = _ref.initialSelectedItem,
      label = _ref.label,
      _ref$onChange = _ref.onChange,
      onChange = _ref$onChange === void 0 ? function () {} : _ref$onChange;
  return /*#__PURE__*/React.createElement(MenuGroup, {
    label: label
  }, /*#__PURE__*/React.createElement(MenuRadioGroupOptions, {
    items: items,
    initialSelectedItem: initialSelectedItem,
    onChange: onChange
  }));
}

MenuRadioGroup.propTypes = {
  /**
   * Whether the option should be checked by default
   */
  initialSelectedItem: PropTypes.string,

  /**
   * Array of the radio options
   */
  items: PropTypes.arrayOf(PropTypes.string).isRequired,

  /**
   * The radio group label
   */
  label: PropTypes.string.isRequired,

  /**
   * Callback function when selection the has been changed
   */
  onChange: PropTypes.func
};
export default MenuRadioGroup;