import _slicedToArray from "@babel/runtime/helpers/slicedToArray";

/**
 * Copyright IBM Corp. 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useState } from 'react';
import PropTypes from 'prop-types';
import { Checkmark16 } from '@carbon/icons-react';
import MenuOption from './MenuOption';

function MenuRadioGroupOptions(_ref) {
  var items = _ref.items,
      initialSelectedItem = _ref.initialSelectedItem,
      _ref$onChange = _ref.onChange,
      onChange = _ref$onChange === void 0 ? function () {} : _ref$onChange;

  var _useState = useState(initialSelectedItem),
      _useState2 = _slicedToArray(_useState, 2),
      selected = _useState2[0],
      setSelected = _useState2[1];

  function handleClick(option) {
    setSelected(option);
    onChange(option);
  }

  var options = items.map(function (option, i) {
    var isSelected = selected === option;
    return /*#__PURE__*/React.createElement(MenuOption, {
      key: i,
      role: "menuitemradio",
      "aria-checked": isSelected,
      renderIcon: isSelected ? Checkmark16 : null,
      label: option,
      indented: true,
      onClick: function onClick() {
        handleClick(option);
      }
    });
  });
  return options;
}

MenuRadioGroupOptions.propTypes = {
  /**
   * Whether the option should be checked by default
   */
  initialSelectedItem: PropTypes.string,

  /**
   * Array of the radio options
   */
  items: PropTypes.arrayOf(PropTypes.string).isRequired,

  /**
   * Callback function when selection the has been changed
   */
  onChange: PropTypes.func
};
export default MenuRadioGroupOptions;