import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["size", "numberOfButtons", "hasScrollingContent"],
    _excluded2 = ["passiveModal"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useState } from 'react';
import ReactDOM from 'react-dom';
import { action } from '@storybook/addon-actions';
import Modal from './Modal';
import Button from '../../Button';
import Select from '../../Select';
import MultiSelect from '../../MultiSelect';
import Dropdown from '../../Dropdown';
import SelectItem from '../../SelectItem';
import TextInput from '../../TextInput';
import mdx from '../Modal.mdx';
var buttons = {
  'None (0)': '0',
  'One (1)': '1',
  'Two (2)': '2',
  'Three (3)': '3'
};
var props = {
  modal: function modal() {
    return {
      numberOfButtons: ('Number of Buttons', buttons, '2'),
      className: 'some-class',
      open: true,
      danger: false,
      alert: false,
      shouldSubmitOnEnter: false,
      hasScrollingContent: false,
      hasForm: false,
      modalHeading: 'Modal heading',
      modalLabel: 'Label',
      modalAriaLabel: 'A label to be read by screen readers on the modal root node',
      selectorPrimaryFocus: '[data-modal-primary-focus]',
      size: 'md',
      onBlur: action('onBlur'),
      onClick: action('onClick'),
      onFocus: action('onFocus'),
      onRequestClose: action('onRequestClose'),
      onRequestSubmit: action('onRequestSubmit'),
      onSecondarySubmit: action('onSecondarySubmit'),
      preventCloseOnClickOutside: true,
      primaryButtonDisabled: false,
      primaryButtonText: 'Primary button'
    };
  },
  modalFooter: function modalFooter(numberOfButtons) {
    var secondaryButtons = function secondaryButtons() {
      switch (numberOfButtons) {
        case '2':
          return {
            secondaryButtonText: 'Secondary button'
          };

        case '3':
          return {
            secondaryButtons: [{
              buttonText: 'Keep both',
              onClick: action('onClick')
            }, {
              buttonText: 'Rename',
              onClick: action('onClick')
            }]
          };

        default:
          return null;
      }
    };

    return _objectSpread({
      passiveModal: false || numberOfButtons === '0'
    }, secondaryButtons());
  }
};
export default {
  title: 'Components/Modal',
  parameters: {
    component: Modal,
    docs: {
      page: mdx
    }
  }
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(Modal, {
    open: true,
    modalHeading: "Add a custom domain",
    modalLabel: "Account resources",
    primaryButtonText: "Add",
    secondaryButtonText: "Cancel"
  }, /*#__PURE__*/React.createElement("p", {
    style: {
      marginBottom: '1rem'
    }
  }, "Custom domains direct requests for your apps in this Cloud Foundry organization to a URL that you own. A custom domain can be a shared domain, a shared subdomain, or a shared domain and host."), /*#__PURE__*/React.createElement(TextInput, {
    "data-modal-primary-focus": true,
    id: "text-input-1",
    labelText: "Domain name",
    placeholder: "e.g. github.com",
    style: {
      marginBottom: '1rem'
    }
  }), /*#__PURE__*/React.createElement(Select, {
    id: "select-1",
    defaultValue: "us-south",
    labelText: "Region"
  }, /*#__PURE__*/React.createElement(SelectItem, {
    value: "us-south",
    text: "US South"
  }), /*#__PURE__*/React.createElement(SelectItem, {
    value: "us-east",
    text: "US East"
  })), /*#__PURE__*/React.createElement(Dropdown, {
    id: "drop",
    label: "Dropdown",
    titleText: "Dropdown",
    items: [{
      id: 'one',
      label: 'one',
      name: 'one'
    }, {
      id: 'two',
      label: 'two',
      name: 'two'
    }]
  }), /*#__PURE__*/React.createElement(MultiSelect, {
    id: "test",
    label: "Multiselect",
    items: [{
      id: 'downshift-1-item-0',
      text: 'Option 1'
    }, {
      id: 'downshift-1-item-1',
      text: 'Option 2'
    }],
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    }
  }));
};
export var Playground = function Playground() {
  var _props$modal = props.modal(),
      size = _props$modal.size,
      numberOfButtons = _props$modal.numberOfButtons,
      hasScrollingContent = _props$modal.hasScrollingContent,
      modalProps = _objectWithoutProperties(_props$modal, _excluded);

  var _props$modalFooter = props.modalFooter(numberOfButtons),
      passiveModal = _props$modalFooter.passiveModal,
      footerProps = _objectWithoutProperties(_props$modalFooter, _excluded2);

  return /*#__PURE__*/React.createElement(Modal, _extends({
    passiveModal: numberOfButtons === '0' || passiveModal,
    size: size || undefined,
    hasScrollingContent: hasScrollingContent,
    "aria-label": hasScrollingContent ? 'Modal content' : undefined
  }, modalProps, footerProps), /*#__PURE__*/React.createElement("p", {
    style: {
      marginBottom: '1rem'
    }
  }, "Custom domains direct requests for your apps in this Cloud Foundry organization to a URL that you own. A custom domain can be a shared domain, a shared subdomain, or a shared domain and host."), /*#__PURE__*/React.createElement(TextInput, {
    "data-modal-primary-focus": true,
    id: "text-input-1",
    labelText: "Domain name",
    placeholder: "e.g. github.com",
    style: {
      marginBottom: '1rem'
    }
  }), /*#__PURE__*/React.createElement(Select, {
    id: "select-1",
    defaultValue: "us-south",
    labelText: "Region"
  }, /*#__PURE__*/React.createElement(SelectItem, {
    value: "us-south",
    text: "US South"
  }), /*#__PURE__*/React.createElement(SelectItem, {
    value: "us-east",
    text: "US East"
  })), /*#__PURE__*/React.createElement("br", null), hasScrollingContent && /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), /*#__PURE__*/React.createElement("h3", null, "Lorem ipsum"), /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' ')));
};
export var WithStateManager = function WithStateManager() {
  /**
   * Simple state manager for modals.
   */
  var ModalStateManager = function ModalStateManager(_ref) {
    var LauncherContent = _ref.renderLauncher,
        ModalContent = _ref.children;

    var _useState = useState(false),
        _useState2 = _slicedToArray(_useState, 2),
        open = _useState2[0],
        setOpen = _useState2[1];

    return /*#__PURE__*/React.createElement(React.Fragment, null, !ModalContent || typeof document === 'undefined' ? null : /*#__PURE__*/ReactDOM.createPortal( /*#__PURE__*/React.createElement(ModalContent, {
      open: open,
      setOpen: setOpen
    }), document.body), LauncherContent && /*#__PURE__*/React.createElement(LauncherContent, {
      open: open,
      setOpen: setOpen
    }));
  };

  return /*#__PURE__*/React.createElement(ModalStateManager, {
    renderLauncher: function renderLauncher(_ref2) {
      var setOpen = _ref2.setOpen;
      return /*#__PURE__*/React.createElement(Button, {
        onClick: function onClick() {
          return setOpen(true);
        }
      }, "Launch modal");
    }
  }, function (_ref3) {
    var open = _ref3.open,
        setOpen = _ref3.setOpen;
    return /*#__PURE__*/React.createElement(Modal, {
      modalHeading: "Add a custom domain",
      modalLabel: "Account resources",
      primaryButtonText: "Add",
      secondaryButtonText: "Cancel",
      open: open,
      onRequestClose: function onRequestClose() {
        return setOpen(false);
      }
    }, /*#__PURE__*/React.createElement("p", {
      style: {
        marginBottom: '1rem'
      }
    }, "Custom domains direct requests for your apps in this Cloud Foundry organization to a URL that you own. A custom domain can be a shared domain, a shared subdomain, or a shared domain and host."), /*#__PURE__*/React.createElement(TextInput, {
      "data-modal-primary-focus": true,
      id: "text-input-1",
      labelText: "Domain name",
      placeholder: "e.g. github.com",
      style: {
        marginBottom: '1rem'
      }
    }), /*#__PURE__*/React.createElement(Select, {
      id: "select-1",
      defaultValue: "us-south",
      labelText: "Region"
    }, /*#__PURE__*/React.createElement(SelectItem, {
      value: "us-south",
      text: "US South"
    }), /*#__PURE__*/React.createElement(SelectItem, {
      value: "us-east",
      text: "US East"
    })));
  });
};
export var PassiveModal = function PassiveModal() {
  return /*#__PURE__*/React.createElement(Modal, {
    open: true,
    passiveModal: true,
    modalHeading: "You have been successfully signed out"
  });
};