import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["listBoxMenuIconTranslationIds", "selectionFeedback"],
    _excluded2 = ["listBoxMenuIconTranslationIds", "selectionFeedback"],
    _excluded3 = ["listBoxMenuIconTranslationIds", "selectionFeedback"],
    _excluded4 = ["listBoxMenuIconTranslationIds", "selectionFeedback"],
    _excluded5 = ["listBoxMenuIconTranslationIds", "selectionFeedback"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useCallback, useState } from 'react';
import { action } from '@storybook/addon-actions';
import { withKnobs, boolean, select, text, object } from '@storybook/addon-knobs';
import { withReadme } from 'storybook-readme';
import readme from './README.md';
import MultiSelect from '../MultiSelect';
import FilterableMultiSelect from '../MultiSelect/FilterableMultiSelect';
import Checkbox from '../Checkbox';
import mdx from './MultiSelect.mdx';
import Button from '../Button';
var items = [{
  id: 'downshift-1-item-0',
  text: 'Option 1'
}, {
  id: 'downshift-1-item-1',
  text: 'Option 2'
}, {
  id: 'downshift-1-item-2',
  text: 'Option 3 - a disabled item',
  disabled: true
}, {
  id: 'downshift-1-item-3',
  text: 'Option 4'
}, {
  id: 'downshift-1-item-4',
  text: 'An example option that is really long to show what should be done to handle long text'
}, {
  id: 'downshift-1-item-5',
  text: 'Option 5'
}];
var defaultLabel = 'MultiSelect Label';
var defaultPlaceholder = 'Filter';
var types = {
  'Default (default)': 'default',
  'Inline (inline)': 'inline'
};
var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined,
  'Large  (lg)': 'lg'
};
var directions = {
  'Bottom (default)': 'bottom',
  'Top ': 'top'
};

var props = function props() {
  return {
    id: text('MultiSelect ID (id)', 'carbon-multiselect-example'),
    titleText: text('Title (titleText)', 'Multiselect title'),
    hideLabel: boolean('No title text shown (hideLabel)', false),
    helperText: text('Helper text (helperText)', 'This is helper text'),
    disabled: boolean('Disabled (disabled)', false),
    light: boolean('Light variant (light)', false),
    useTitleInItem: boolean('Show tooltip on hover', false),
    type: select('UI type (Only for `<MultiSelect>`) (type)', types, 'default'),
    size: select('Field size (size)', sizes, undefined) || undefined,
    direction: select('Dropdown direction (direction)', directions, 'bottom'),
    label: text('Label (label)', defaultLabel),
    invalid: boolean('Show form validation UI (invalid)', false),
    invalidText: text('Form validation UI content (invalidText)', 'Invalid Selection'),
    warn: boolean('Show warning state (warn)', false),
    warnText: text('Warning state text (warnText)', 'Selecting more items may increase processing time'),
    onChange: action('onChange'),
    onMenuChange: action('onMenuChange'),
    listBoxMenuIconTranslationIds: object('Listbox menu icon translation IDs (for translateWithId callback)', {
      'close.menu': 'Close menu',
      'open.menu': 'Open menu',
      'clear.all': 'Clear all',
      'clear.selection': 'Clear selection'
    }),
    selectionFeedback: select('Selection feedback', ['top', 'fixed', 'top-after-reopen'], 'top-after-reopen')
  };
};

export default {
  title: 'Components/MultiSelect',
  decorators: [withKnobs],
  parameters: {
    component: MultiSelect,
    docs: {
      page: mdx
    },
    subcomponents: {
      FilterableMultiSelect: FilterableMultiSelect
    }
  }
};
export var Default = withReadme(readme, function () {
  var _props = props(),
      listBoxMenuIconTranslationIds = _props.listBoxMenuIconTranslationIds,
      selectionFeedback = _props.selectionFeedback,
      multiSelectProps = _objectWithoutProperties(_props, _excluded);

  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/React.createElement(MultiSelect, _extends({}, multiSelectProps, {
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    translateWithId: function translateWithId(id) {
      return listBoxMenuIconTranslationIds[id];
    },
    selectionFeedback: selectionFeedback
  })));
});
export var controlled = withReadme(readme, function () {
  var _props2 = props(),
      listBoxMenuIconTranslationIds = _props2.listBoxMenuIconTranslationIds,
      selectionFeedback = _props2.selectionFeedback,
      multiSelectProps = _objectWithoutProperties(_props2, _excluded2);

  var _useState = useState([]),
      _useState2 = _slicedToArray(_useState, 2),
      selectedItems = _useState2[0],
      setSelectedItems = _useState2[1];

  var onChange = useCallback(function (_ref) {
    var newSelectedItems = _ref.selectedItems;
    setSelectedItems(newSelectedItems);
  }, []);
  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/React.createElement(MultiSelect, _extends({}, multiSelectProps, {
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    translateWithId: function translateWithId(id) {
      return listBoxMenuIconTranslationIds[id];
    },
    selectionFeedback: selectionFeedback,
    onChange: onChange,
    selectedItems: selectedItems
  })), /*#__PURE__*/React.createElement(Button, {
    onClick: function onClick() {
      setSelectedItems([{
        id: 'downshift-1-item-0',
        text: 'Option 1'
      }]);
    }
  }, "click to select only Option 1"), /*#__PURE__*/React.createElement(Button, {
    onClick: function onClick() {
      setSelectedItems([]);
    }
  }, "click to clear selections"));
});
export var ItemToElement = withReadme(readme, function () {
  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/React.createElement(MultiSelect, {
    titleText: "Multiselect with element items",
    label: "Choose an item",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    itemToElement: function itemToElement(item) {
      return item ? /*#__PURE__*/React.createElement("span", {
        className: "test"
      }, item.text, ' ', /*#__PURE__*/React.createElement("span", {
        role: "img",
        alt: "fire"
      }, ' ', "\uD83D\uDD25")) : '';
    }
  }), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement(FilterableMultiSelect, {
    titleText: "Filterable Multiselect with element items",
    placeholder: "itemToElement example",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    itemToElement: function itemToElement(item) {
      return item ? /*#__PURE__*/React.createElement("span", {
        className: "test"
      }, item.text, ' ', /*#__PURE__*/React.createElement("span", {
        role: "img",
        alt: "fire"
      }, ' ', "\uD83D\uDD25")) : '';
    }
  }));
});
Default.storyName = 'default';
Default.parameters = {
  info: {
    text: "\n        MultiSelect\n      "
  }
};
export var WithInitialSelectedItems = withReadme(readme, function () {
  var _props3 = props(),
      listBoxMenuIconTranslationIds = _props3.listBoxMenuIconTranslationIds,
      selectionFeedback = _props3.selectionFeedback,
      multiSelectProps = _objectWithoutProperties(_props3, _excluded3);

  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/React.createElement(MultiSelect, _extends({}, multiSelectProps, {
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    initialSelectedItems: [items[0], items[1]],
    translateWithId: function translateWithId(id) {
      return listBoxMenuIconTranslationIds[id];
    },
    selectionFeedback: selectionFeedback
  })));
});
WithInitialSelectedItems.storyName = 'with initial selected items';
WithInitialSelectedItems.parameters = {
  info: {
    text: "\n        Provide a set of items to initially select in the control\n      "
  }
};
export var _Filterable = withReadme(readme, function () {
  var _props4 = props(),
      listBoxMenuIconTranslationIds = _props4.listBoxMenuIconTranslationIds,
      selectionFeedback = _props4.selectionFeedback,
      multiSelectProps = _objectWithoutProperties(_props4, _excluded4);

  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/React.createElement(FilterableMultiSelect, _extends({}, multiSelectProps, {
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    placeholder: defaultPlaceholder,
    translateWithId: function translateWithId(id) {
      return listBoxMenuIconTranslationIds[id];
    },
    selectionFeedback: selectionFeedback,
    onMenuChange: function onMenuChange(e) {
      multiSelectProps.onMenuChange(e);
    }
  })));
});
_Filterable.storyName = 'filterable';
_Filterable.parameters = {
  info: {
    text: "\n        When a list contains more than 25 items, use `MultiSelect.Filterable` to help find options from the list.\n      "
  }
};
export var WithChangeOnClose = withReadme(readme, function () {
  var _props5 = props(),
      listBoxMenuIconTranslationIds = _props5.listBoxMenuIconTranslationIds,
      selectionFeedback = _props5.selectionFeedback,
      multiSelectProps = _objectWithoutProperties(_props5, _excluded5);

  var _useState3 = useState(false),
      _useState4 = _slicedToArray(_useState3, 2),
      hasFocus = _useState4[0],
      setHasFocus = _useState4[1];

  var _useState5 = useState(false),
      _useState6 = _slicedToArray(_useState5, 2),
      active = _useState6[0],
      setActive = _useState6[1];

  var _useState7 = useState([items[0]]),
      _useState8 = _slicedToArray(_useState7, 2),
      selItems = _useState8[0],
      setSelItems = _useState8[1];

  if (!hasFocus && active && selItems.length == 0) {
    setActive(false);
  }

  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/React.createElement(Checkbox, {
    id: "active",
    checked: active,
    onChange: function onChange(a) {
      setActive(a);

      if (a) {
        setSelItems([items[0]]);
      }
    },
    labelText: "Active"
  }), /*#__PURE__*/React.createElement(MultiSelect, _extends({}, multiSelectProps, {
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    translateWithId: function translateWithId(id) {
      return listBoxMenuIconTranslationIds[id];
    },
    selectionFeedback: selectionFeedback,
    key: active,
    disabled: !active,
    initialSelectedItems: selItems,
    onMenuChange: function onMenuChange(e) {
      multiSelectProps.onMenuChange(e);
      setHasFocus(e);
    },
    onChange: function onChange(e) {
      setSelItems(e.selectedItems);
    }
  })));
});