import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { WarningFilled16, WarningAltFilled16 } from '@carbon/icons-react';
import cx from 'classnames';
import Downshift, { useSelect } from 'downshift';
import isEqual from 'lodash.isequal';
import PropTypes from 'prop-types';
import React, { useRef, useState } from 'react';
import ListBox, { PropTypes as ListBoxPropTypes } from '../ListBox';
import { sortingPropTypes } from './MultiSelectPropTypes';
import { defaultItemToString } from './tools/itemToString';
import { defaultSortItems, defaultCompareItems } from './tools/sorting';
import { useSelection } from '../../internal/Selection';
import setupGetInstanceId from '../../tools/setupGetInstanceId';
import { mapDownshiftProps } from '../../tools/createPropAdapter';
import mergeRefs from '../../tools/mergeRefs';
import { keys, match } from '../../internal/keyboard';
import { useFeatureFlag } from '../FeatureFlags';
import { usePrefix } from '../../internal/usePrefix';

var noop = function noop() {};

var getInstanceId = setupGetInstanceId();
var _useSelect$stateChang = useSelect.stateChangeTypes,
    ItemClick = _useSelect$stateChang.ItemClick,
    MenuBlur = _useSelect$stateChang.MenuBlur,
    MenuKeyDownArrowDown = _useSelect$stateChang.MenuKeyDownArrowDown,
    MenuKeyDownArrowUp = _useSelect$stateChang.MenuKeyDownArrowUp,
    MenuKeyDownEnter = _useSelect$stateChang.MenuKeyDownEnter,
    MenuKeyDownEscape = _useSelect$stateChang.MenuKeyDownEscape,
    MenuKeyDownSpaceButton = _useSelect$stateChang.MenuKeyDownSpaceButton,
    ToggleButtonClick = _useSelect$stateChang.ToggleButtonClick;
var MultiSelect = /*#__PURE__*/React.forwardRef(function MultiSelect(_ref, ref) {
  var _cx, _cx2, _cx4;

  var containerClassName = _ref.className,
      id = _ref.id,
      items = _ref.items,
      itemToElement = _ref.itemToElement,
      _itemToString = _ref.itemToString,
      titleText = _ref.titleText,
      hideLabel = _ref.hideLabel,
      helperText = _ref.helperText,
      label = _ref.label,
      type = _ref.type,
      size = _ref.size,
      disabled = _ref.disabled,
      initialSelectedItems = _ref.initialSelectedItems,
      sortItems = _ref.sortItems,
      compareItems = _ref.compareItems,
      clearSelectionText = _ref.clearSelectionText,
      clearSelectionDescription = _ref.clearSelectionDescription,
      light = _ref.light,
      invalid = _ref.invalid,
      invalidText = _ref.invalidText,
      warn = _ref.warn,
      warnText = _ref.warnText,
      useTitleInItem = _ref.useTitleInItem,
      translateWithId = _ref.translateWithId,
      downshiftProps = _ref.downshiftProps,
      open = _ref.open,
      selectionFeedback = _ref.selectionFeedback,
      onChange = _ref.onChange,
      onMenuChange = _ref.onMenuChange,
      direction = _ref.direction,
      selected = _ref.selectedItems;
  var prefix = usePrefix();

  var _useRef = useRef(getInstanceId()),
      multiSelectInstanceId = _useRef.current;

  var _useState = useState(null),
      _useState2 = _slicedToArray(_useState, 2),
      highlightedIndex = _useState2[0],
      setHighlightedIndex = _useState2[1];

  var _useState3 = useState(open),
      _useState4 = _slicedToArray(_useState3, 2),
      isOpen = _useState4[0],
      setIsOpen = _useState4[1];

  var _useState5 = useState(open),
      _useState6 = _slicedToArray(_useState5, 2),
      prevOpenProp = _useState6[0],
      setPrevOpenProp = _useState6[1];

  var _useState7 = useState([]),
      _useState8 = _slicedToArray(_useState7, 2),
      topItems = _useState8[0],
      setTopItems = _useState8[1];

  var _useSelection = useSelection({
    disabled: disabled,
    initialSelectedItems: initialSelectedItems,
    onChange: onChange,
    selectedItems: selected
  }),
      controlledSelectedItems = _useSelection.selectedItems,
      onItemChange = _useSelection.onItemChange,
      clearSelection = _useSelection.clearSelection;

  var _useSelect = useSelect(mapDownshiftProps(_objectSpread(_objectSpread({}, downshiftProps), {}, {
    highlightedIndex: highlightedIndex,
    isOpen: isOpen,
    itemToString: function itemToString(items) {
      return items.map(function (item) {
        return _itemToString(item);
      }).join(', ');
    },
    onStateChange: onStateChange,
    selectedItem: controlledSelectedItems,
    items: items
  }))),
      getToggleButtonProps = _useSelect.getToggleButtonProps,
      getLabelProps = _useSelect.getLabelProps,
      getMenuProps = _useSelect.getMenuProps,
      getItemProps = _useSelect.getItemProps,
      selectedItems = _useSelect.selectedItem;
  /**
   * wrapper function to forward changes to consumer
   */


  var setIsOpenWrapper = function setIsOpenWrapper(open) {
    setIsOpen(open);

    if (onMenuChange) {
      onMenuChange(open);
    }
  };
  /**
   * programmatically control this `open` prop
   */


  if (prevOpenProp !== open) {
    setIsOpenWrapper(open);
    setPrevOpenProp(open);
  }

  var inline = type === 'inline';
  var showWarning = !invalid && warn;
  var enabled = useFeatureFlag('enable-v11-release');
  var wrapperClasses = cx("".concat(prefix, "--multi-select__wrapper"), "".concat(prefix, "--list-box__wrapper"), [enabled ? containerClassName : null], (_cx = {}, _defineProperty(_cx, "".concat(prefix, "--multi-select__wrapper--inline"), inline), _defineProperty(_cx, "".concat(prefix, "--list-box__wrapper--inline"), inline), _defineProperty(_cx, "".concat(prefix, "--multi-select__wrapper--inline--invalid"), inline && invalid), _defineProperty(_cx, "".concat(prefix, "--list-box__wrapper--inline--invalid"), inline && invalid), _cx));
  var titleClasses = cx("".concat(prefix, "--label"), (_cx2 = {}, _defineProperty(_cx2, "".concat(prefix, "--label--disabled"), disabled), _defineProperty(_cx2, "".concat(prefix, "--visually-hidden"), hideLabel), _cx2));
  var helperId = !helperText ? undefined : "multiselect-helper-text-".concat(multiSelectInstanceId);
  var fieldLabelId = "multiselect-field-label-".concat(multiSelectInstanceId);
  var helperClasses = cx("".concat(prefix, "--form__helper-text"), _defineProperty({}, "".concat(prefix, "--form__helper-text--disabled"), disabled));
  var className = cx("".concat(prefix, "--multi-select"), [enabled ? null : containerClassName], (_cx4 = {}, _defineProperty(_cx4, "".concat(prefix, "--multi-select--invalid"), invalid), _defineProperty(_cx4, "".concat(prefix, "--multi-select--warning"), showWarning), _defineProperty(_cx4, "".concat(prefix, "--multi-select--inline"), inline), _defineProperty(_cx4, "".concat(prefix, "--multi-select--selected"), selectedItems && selectedItems.length > 0), _defineProperty(_cx4, "".concat(prefix, "--list-box--up"), direction === 'top'), _cx4)); // needs to be capitalized for react to render it correctly

  var ItemToElement = itemToElement;
  var sortOptions = {
    selectedItems: controlledSelectedItems,
    itemToString: _itemToString,
    compareItems: compareItems,
    locale: 'en'
  };

  if (selectionFeedback === 'fixed') {
    sortOptions.selectedItems = [];
  } else if (selectionFeedback === 'top-after-reopen') {
    sortOptions.selectedItems = topItems;
  }

  function onStateChange(changes) {
    if (changes.isOpen && !isOpen) {
      setTopItems(controlledSelectedItems);
    }

    var type = changes.type;

    switch (type) {
      case ItemClick:
      case MenuKeyDownSpaceButton:
      case MenuKeyDownEnter:
        if (changes.selectedItem === undefined) {
          break;
        }

        onItemChange(changes.selectedItem);
        break;

      case MenuKeyDownArrowDown:
      case MenuKeyDownArrowUp:
        setHighlightedIndex(changes.highlightedIndex);
        break;

      case MenuBlur:
      case MenuKeyDownEscape:
        setIsOpenWrapper(false);
        setHighlightedIndex(changes.highlightedIndex);
        break;

      case ToggleButtonClick:
        setIsOpenWrapper(changes.isOpen || false);
        setHighlightedIndex(changes.highlightedIndex);
        break;
    }
  }

  var onKeyDown = function onKeyDown(e) {
    if (match(e, keys.Delete) && !disabled) {
      clearSelection();
      e.stopPropagation();
    }
  };

  var toggleButtonProps = getToggleButtonProps();
  return /*#__PURE__*/React.createElement("div", {
    className: wrapperClasses
  }, /*#__PURE__*/React.createElement("label", _extends({
    className: titleClasses
  }, getLabelProps()), titleText && titleText, selectedItems.length > 0 && /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--visually-hidden")
  }, clearSelectionDescription, " ", selectedItems.length, ",", clearSelectionText)), /*#__PURE__*/React.createElement(ListBox, {
    type: type,
    size: size,
    className: className,
    disabled: disabled,
    light: light,
    invalid: invalid,
    invalidText: invalidText,
    warn: warn,
    warnText: warnText,
    isOpen: isOpen,
    id: id
  }, invalid && /*#__PURE__*/React.createElement(WarningFilled16, {
    className: "".concat(prefix, "--list-box__invalid-icon")
  }), showWarning && /*#__PURE__*/React.createElement(WarningAltFilled16, {
    className: "".concat(prefix, "--list-box__invalid-icon ").concat(prefix, "--list-box__invalid-icon--warning")
  }), /*#__PURE__*/React.createElement("button", _extends({
    type: "button",
    className: "".concat(prefix, "--list-box__field"),
    disabled: disabled,
    "aria-disabled": disabled
  }, toggleButtonProps, {
    ref: mergeRefs(toggleButtonProps.ref, ref),
    onKeyDown: onKeyDown
  }), selectedItems.length > 0 && /*#__PURE__*/React.createElement(ListBox.Selection, {
    clearSelection: !disabled ? clearSelection : noop,
    selectionCount: selectedItems.length,
    translateWithId: translateWithId,
    disabled: disabled
  }), /*#__PURE__*/React.createElement("span", {
    id: fieldLabelId,
    className: "".concat(prefix, "--list-box__label")
  }, label), /*#__PURE__*/React.createElement(ListBox.MenuIcon, {
    isOpen: isOpen,
    translateWithId: translateWithId
  })), /*#__PURE__*/React.createElement(ListBox.Menu, _extends({
    "aria-multiselectable": "true"
  }, getMenuProps()), isOpen && sortItems(items, sortOptions).map(function (item, index) {
    var _getItemProps;

    var itemProps = getItemProps((_getItemProps = {
      item: item
    }, _defineProperty(_getItemProps, 'aria-selected', isChecked ? true : null), _defineProperty(_getItemProps, "disabled", item.disabled), _getItemProps));

    var itemText = _itemToString(item);

    var isChecked = selectedItems.filter(function (selected) {
      return isEqual(selected, item);
    }).length > 0;
    return /*#__PURE__*/React.createElement(ListBox.MenuItem, _extends({
      key: itemProps.id,
      isActive: isChecked,
      "aria-label": itemText,
      isHighlighted: highlightedIndex === index,
      title: itemText
    }, itemProps), /*#__PURE__*/React.createElement("div", {
      className: "".concat(prefix, "--checkbox-wrapper")
    }, /*#__PURE__*/React.createElement("span", {
      title: useTitleInItem ? itemText : null,
      className: "".concat(prefix, "--checkbox-label"),
      "data-contained-checkbox-state": isChecked,
      id: "".concat(itemProps.id, "__checkbox")
    }, itemToElement ? /*#__PURE__*/React.createElement(ItemToElement, _extends({
      key: itemProps.id
    }, item)) : itemText)));
  }))), !inline && !invalid && !warn && helperText && /*#__PURE__*/React.createElement("div", {
    id: helperId,
    className: helperClasses
  }, helperText));
});
MultiSelect.displayName = 'MultiSelect';
MultiSelect.propTypes = _objectSpread(_objectSpread({}, sortingPropTypes), {}, {
  /**
   * Specify the text that should be read for screen readers that describes total items selected
   */
  clearSelectionDescription: PropTypes.string,

  /**
   * Specify the text that should be read for screen readers to clear selection.
   */
  clearSelectionText: PropTypes.string,

  /**
   * Specify the direction of the multiselect dropdown. Can be either top or bottom.
   */
  direction: PropTypes.oneOf(['top', 'bottom']),

  /**
   * Disable the control
   */
  disabled: PropTypes.bool,

  /**
   * Additional props passed to Downshift
   */
  downshiftProps: PropTypes.shape(Downshift.propTypes),

  /**
   * Specify whether the title text should be hidden or not
   */
  hideLabel: PropTypes.bool,

  /**
   * Specify a custom `id`
   */
  id: PropTypes.string.isRequired,

  /**
   * Allow users to pass in arbitrary items from their collection that are
   * pre-selected
   */
  initialSelectedItems: PropTypes.array,

  /**
   * Is the current selection invalid?
   */
  invalid: PropTypes.bool,

  /**
   * If invalid, what is the error?
   */
  invalidText: PropTypes.node,

  /**
   * Function to render items as custom components instead of strings.
   * Defaults to null and is overridden by a getter
   */
  itemToElement: PropTypes.func,

  /**
   * Helper function passed to downshift that allows the library to render a
   * given item to a string label. By default, it extracts the `label` field
   * from a given item to serve as the item label in the list.
   */
  itemToString: PropTypes.func,

  /**
   * We try to stay as generic as possible here to allow individuals to pass
   * in a collection of whatever kind of data structure they prefer
   */
  items: PropTypes.array.isRequired,

  /**
   * Generic `label` that will be used as the textual representation of what
   * this field is for
   */
  label: PropTypes.node.isRequired,

  /**
   * `true` to use the light version.
   */
  light: PropTypes.bool,

  /**
   * Specify the locale of the control. Used for the default `compareItems`
   * used for sorting the list of items in the control.
   */
  locale: PropTypes.string,

  /**
   * `onChange` is a utility for this controlled component to communicate to a
   * consuming component what kind of internal state changes are occurring.
   */
  onChange: PropTypes.func,

  /**
   * `onMenuChange` is a utility for this controlled component to communicate to a
   * consuming component that the menu was opend(`true`)/closed(`false`).
   */
  onMenuChange: PropTypes.func,

  /**
   * Initialize the component with an open(`true`)/closed(`false`) menu.
   */
  open: PropTypes.bool,

  /**
   * For full control of the selected items
   */
  selectedItems: PropTypes.array,

  /**
   * Specify feedback (mode) of the selection.
   * `top`: selected item jumps to top
   * `fixed`: selected item stays at it's position
   * `top-after-reopen`: selected item jump to top after reopen dropdown
   */
  selectionFeedback: PropTypes.oneOf(['top', 'fixed', 'top-after-reopen']),

  /**
   * Specify the size of the ListBox. Currently supports either `sm`, `md` or `lg` as an option.
   */
  size: ListBoxPropTypes.ListBoxSize,

  /**
   * Provide text to be used in a `<label>` element that is tied to the
   * multiselect via ARIA attributes.
   */
  titleText: PropTypes.node,

  /**
   * Callback function for translating ListBoxMenuIcon SVG title
   */
  translateWithId: PropTypes.func,

  /**
   * Specify 'inline' to create an inline multi-select.
   */
  type: PropTypes.oneOf(['default', 'inline']),

  /**
   * Specify title to show title on hover
   */
  useTitleInItem: PropTypes.bool,

  /**
   * Specify whether the control is currently in warning state
   */
  warn: PropTypes.bool,

  /**
   * Provide the text that is displayed when the control is in warning state
   */
  warnText: PropTypes.node
});
MultiSelect.defaultProps = {
  compareItems: defaultCompareItems,
  disabled: false,
  locale: 'en',
  itemToString: defaultItemToString,
  initialSelectedItems: [],
  sortItems: defaultSortItems,
  type: 'default',
  light: false,
  title: false,
  open: false,
  selectionFeedback: 'top-after-reopen',
  direction: 'bottom',
  clearSelectionText: 'To clear selection, press Delete or Backspace,',
  clearSelectionDescription: 'Total items selected: ',
  selectedItems: null
};
export default MultiSelect;