/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import MultiSelect from '../';
import FilterableMultiSelect from './FilterableMultiSelect';
import { Layer } from '../../Layer';
var items = [{
  id: 'downshift-1-item-0',
  text: 'Option 1'
}, {
  id: 'downshift-1-item-1',
  text: 'Option 2'
}, {
  id: 'downshift-1-item-2',
  text: 'Option 3 - a disabled item',
  disabled: true
}, {
  id: 'downshift-1-item-3',
  text: 'Option 4'
}, {
  id: 'downshift-1-item-4',
  text: 'An example option that is really long to show what should be done to handle long text'
}, {
  id: 'downshift-1-item-5',
  text: 'Option 5'
}];
export default {
  title: 'Components/MultiSelect',
  parameters: {
    component: MultiSelect,
    subcomponents: {
      'MultiSelect.Filterable': MultiSelect.Filterable
    }
  }
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/React.createElement(MultiSelect, {
    label: "Multiselect Label",
    id: "carbon-multiselect-example",
    titleText: "Multiselect title",
    helperText: "This is helper text",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    selectionFeedback: "top-after-reopen"
  }));
};
export var WithInitialSelectedItems = function WithInitialSelectedItems() {
  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/React.createElement(MultiSelect, {
    id: "carbon-multiselect-example-2",
    titleText: "Multiselect title",
    helperText: "This is helper text",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    initialSelectedItems: [items[0], items[1]],
    selectionFeedback: "top-after-reopen"
  }));
};
export var _Filterable = function _Filterable() {
  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/React.createElement(FilterableMultiSelect, {
    id: "carbon-multiselect-example-3",
    titleText: "Multiselect title",
    helperText: "This is helper text",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    placeholder: "Filter",
    selectionFeedback: "top-after-reopen"
  }));
};
export var withLayer = function withLayer() {
  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/React.createElement(MultiSelect, {
    label: "First Layer",
    id: "carbon-multiselect-example",
    titleText: "Multiselect title",
    helperText: "This is helper text",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    selectionFeedback: "top-after-reopen"
  }), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(MultiSelect, {
    label: "Second Layer",
    id: "carbon-multiselect-example",
    titleText: "Multiselect title",
    helperText: "This is helper text",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    selectionFeedback: "top-after-reopen"
  }), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(MultiSelect, {
    label: "Third Layer",
    id: "carbon-multiselect-example",
    titleText: "Multiselect title",
    helperText: "This is helper text",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    selectionFeedback: "top-after-reopen"
  }))));
};
export var _FilterableWithLayer = function _FilterableWithLayer() {
  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/React.createElement(FilterableMultiSelect, {
    id: "carbon-multiselect-example-3",
    titleText: "First Layer",
    helperText: "This is helper text",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    placeholder: "Filter",
    selectionFeedback: "top-after-reopen"
  }), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(FilterableMultiSelect, {
    id: "carbon-multiselect-example-3",
    titleText: "Second Layer",
    helperText: "This is helper text",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    placeholder: "Filter",
    selectionFeedback: "top-after-reopen"
  }), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(FilterableMultiSelect, {
    id: "carbon-multiselect-example-3",
    titleText: "Third Layer",
    helperText: "This is helper text",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    placeholder: "Filter",
    selectionFeedback: "top-after-reopen"
  }))));
};