/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { default as NumberInput, NumberInputSkeleton } from '../';
import { Layer } from '../../Layer';
export default {
  title: 'Components/NumberInput',
  parameters: {
    component: NumberInput,
    subcomponents: {
      NumberInputSkeleton: NumberInputSkeleton
    }
  }
};
var numberInputProps = {
  className: 'some-class',
  id: 'number-input-1',
  label: 'Number Input',
  helperText: 'Optional helper text.',
  min: 0,
  max: 100,
  value: 50,
  step: 1
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(NumberInput, numberInputProps);
};
export var withLayer = function withLayer() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(NumberInput, numberInputProps), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(NumberInput, numberInputProps), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(NumberInput, numberInputProps))));
};
export var Skeleton = function Skeleton() {
  return /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(NumberInputSkeleton, null), "\xA0", /*#__PURE__*/React.createElement(NumberInputSkeleton, {
    small: true
  }));
};