/**
 * Copyright IBM Corp. 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { ArrowsVertical16 } from '@carbon/icons-react';
import Menu from '../../Menu';
import { StoryFrame, buildMenu } from '../../Menu/_storybook-utils';
import OverflowMenu from './OverflowMenu';
export default {
  title: 'Experimental/unstable_Menu/OverflowMenu',
  parameters: {
    component: Menu
  }
};

var Story = function Story(items) {
  var props = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  return /*#__PURE__*/React.createElement(StoryFrame, null, /*#__PURE__*/React.createElement(OverflowMenu, props, buildMenu(items)));
};

export var _OverflowMenu = function _OverflowMenu() {
  return Story([{
    type: 'item',
    label: 'Stop app'
  }, {
    type: 'item',
    label: 'Restart app'
  }, {
    type: 'item',
    label: 'Rename app'
  }, {
    type: 'item',
    label: 'Edit routes and access'
  }, {
    type: 'divider'
  }, {
    type: 'item',
    label: 'Delete app',
    kind: 'danger'
  }]);
};
export var CustomIcon = function CustomIcon() {
  return Story([{
    type: 'radiogroup',
    label: 'Sort by',
    items: ['Name', 'Date created', 'Date last modified', 'Size'],
    initialSelectedItem: 'Date created'
  }, {
    type: 'divider'
  }, {
    type: 'radiogroup',
    label: 'Sort order',
    items: ['Ascending', 'Descending'],
    initialSelectedItem: 'Descending'
  }], {
    renderIcon: ArrowsVertical16
  });
};
export var Nested = function Nested() {
  return Story([{
    type: 'item',
    label: 'Level 1'
  }, {
    type: 'item',
    label: 'Level 1'
  }, {
    type: 'item',
    label: 'Level 1',
    children: [{
      type: 'item',
      label: 'Level 2'
    }, {
      type: 'item',
      label: 'Level 2'
    }, {
      type: 'item',
      label: 'Level 2'
    }]
  }, {
    type: 'item',
    label: 'Level 1'
  }]);
};