import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "currentPage", "id", "labelText", "totalPages"];

/**
 * Copyright IBM Corp. 2016, 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import { settings } from 'carbon-components';
import setupGetInstanceId from '../../../tools/setupGetInstanceId';
import Select from '../../Select';
import SelectItem from '../../SelectItem';
var prefix = settings.prefix;
var getInstanceId = setupGetInstanceId();

function PageSelector(_ref) {
  var className = _ref.className,
      currentPage = _ref.currentPage,
      id = _ref.id,
      labelText = _ref.labelText,
      totalPages = _ref.totalPages,
      other = _objectWithoutProperties(_ref, _excluded);

  var namespace = "".concat(prefix, "--unstable-pagination__page-selector");
  var instanceId = "".concat(namespace, "__select-").concat(getInstanceId());

  var renderPages = function renderPages(total) {
    var pages = [];

    for (var counter = 1; counter <= total; counter += 1) {
      pages.push( /*#__PURE__*/React.createElement(SelectItem, {
        key: counter,
        value: counter,
        text: String(counter)
      }));
    }

    return pages;
  };

  return /*#__PURE__*/React.createElement(Select, _extends({
    className: classnames(namespace, className),
    hideLabel: true,
    id: instanceId || id,
    inline: true,
    labelText: labelText,
    value: currentPage
  }, other), renderPages(totalPages));
}

PageSelector.propTypes = {
  /** Extra class names to add. */
  className: PropTypes.string,

  /** The current page. */
  currentPage: PropTypes.number.isRequired,

  /** The unique ID of this component instance. */
  id: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),

  /** Translatable string to label the page selector element. */
  labelText: PropTypes.string,

  /**
   * Total number of pages.
   * This value is calculated using a valid `totalItems` prop passed to the parent `Unstable_Pagination`.
   */
  totalPages: PropTypes.number.isRequired
};
PageSelector.defaultProps = {
  className: null,
  id: 1,
  labelText: 'Current page number'
};
export default PageSelector;