/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import './story.scss';
import { Checkbox16 } from '@carbon/icons-react';
import React from 'react';
import { Popover, PopoverContent } from '../../Popover';
import mdx from './Popover.mdx';
export default {
  title: 'Experimental/unstable_Popover',
  component: Popover,
  subcomponents: {
    PopoverContent: PopoverContent
  },
  argTypes: {
    as: {
      table: {
        disable: true
      }
    },
    children: {
      table: {
        disable: true
      }
    },
    className: {
      table: {
        disable: true
      }
    },
    relative: {
      table: {
        disable: true
      }
    }
  },
  parameters: {
    controls: {
      hideNoControlsWarning: true
    },
    docs: {
      page: mdx
    }
  }
};

var PlaygroundStory = function PlaygroundStory(props) {
  var align = props.align,
      caret = props.caret,
      dropShadow = props.dropShadow,
      highContrast = props.highContrast,
      light = props.light,
      open = props.open;
  return /*#__PURE__*/React.createElement(Popover, {
    align: align,
    caret: caret,
    dropShadow: dropShadow,
    highContrast: highContrast,
    light: light,
    open: open
  }, /*#__PURE__*/React.createElement("div", {
    className: "playground-trigger"
  }, /*#__PURE__*/React.createElement(Checkbox16, null)), /*#__PURE__*/React.createElement(PopoverContent, {
    className: "p-3"
  }, /*#__PURE__*/React.createElement("p", {
    className: "popover-title"
  }, "Available storage"), /*#__PURE__*/React.createElement("p", {
    className: "popover-details"
  }, "This server has 150 GB of block storage remaining.")));
};

export var Playground = PlaygroundStory.bind({});
Playground.argTypes = {
  align: {
    options: ['top', 'top-left', 'top-right', 'bottom', 'bottom-left', 'bottom-right', 'left', 'left-bottom', 'left-top', 'right', 'right-bottom', 'right-top'],
    control: {
      type: 'select'
    }
  },
  caret: {
    control: {
      type: 'boolean'
    },
    defaultValue: true
  },
  dropShadow: {
    control: {
      type: 'boolean'
    },
    defaultValue: true
  },
  highContrast: {
    control: {
      type: 'boolean'
    },
    defaultValue: false
  },
  light: {
    control: {
      type: 'boolean'
    },
    defaultValue: false
  },
  open: {
    control: {
      type: 'boolean'
    },
    defaultValue: true
  }
};
Playground.story = {
  decorators: [function (story) {
    return /*#__PURE__*/React.createElement("div", {
      className: "mt-10 flex justify-center"
    }, story());
  }]
};