import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["label", "description", "className", "current", "complete", "invalid", "secondaryLabel", "disabled", "onClick", "renderLabel", "translateWithId"],
    _excluded2 = ["className", "currentIndex", "vertical", "spaceEqually"];

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React, { Component } from 'react';
import classnames from 'classnames';
import { CheckmarkOutline16, Warning16, RadioButton16, CircleFilled16 } from '@carbon/icons-react';
import { keys, matches } from '../../internal/keyboard';
import { usePrefix, PrefixContext } from '../../internal/usePrefix';

var defaultRenderLabel = function defaultRenderLabel(props) {
  return /*#__PURE__*/React.createElement("p", props);
};

var defaultTranslations = {
  'carbon.progress-step.complete': 'Complete',
  'carbon.progress-step.incomplete': 'Incomplete',
  'carbon.progress-step.current': 'Current',
  'carbon.progress-step.invalid': 'Invalid'
};

function translateWithId(messageId) {
  return defaultTranslations[messageId];
}

export function ProgressStep(_ref) {
  var _classnames;

  var label = _ref.label,
      description = _ref.description,
      className = _ref.className,
      current = _ref.current,
      complete = _ref.complete,
      invalid = _ref.invalid,
      secondaryLabel = _ref.secondaryLabel,
      disabled = _ref.disabled,
      onClick = _ref.onClick,
      ProgressStepLabel = _ref.renderLabel,
      t = _ref.translateWithId,
      rest = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  var classes = classnames((_classnames = {}, _defineProperty(_classnames, "".concat(prefix, "--progress-step"), true), _defineProperty(_classnames, "".concat(prefix, "--progress-step--current"), current), _defineProperty(_classnames, "".concat(prefix, "--progress-step--complete"), complete), _defineProperty(_classnames, "".concat(prefix, "--progress-step--incomplete"), !complete && !current), _defineProperty(_classnames, "".concat(prefix, "--progress-step--disabled"), disabled), _defineProperty(_classnames, className, className), _classnames));

  var handleKeyDown = function handleKeyDown(e) {
    if (matches(e, [keys.Enter, keys.Space])) {
      onClick();
    }
  }; // eslint-disable-next-line react/prop-types


  var SVGIcon = function SVGIcon(_ref2) {
    var complete = _ref2.complete,
        current = _ref2.current,
        description = _ref2.description,
        invalid = _ref2.invalid,
        prefix = _ref2.prefix;

    if (invalid) {
      return /*#__PURE__*/React.createElement(Warning16, {
        className: "".concat(prefix, "--progress__warning")
      }, /*#__PURE__*/React.createElement("title", null, description));
    }

    if (current) {
      return /*#__PURE__*/React.createElement(CircleFilled16, null, /*#__PURE__*/React.createElement("title", null, description));
    }

    if (complete) {
      return /*#__PURE__*/React.createElement(CheckmarkOutline16, null, /*#__PURE__*/React.createElement("title", null, description));
    }

    return /*#__PURE__*/React.createElement(RadioButton16, null, /*#__PURE__*/React.createElement("title", null, description));
  };

  var message = t('carbon.progress-step.incomplete');

  if (current) {
    message = t('carbon.progress-step.current');
  }

  if (complete) {
    message = t('carbon.progress-step.complete');
  }

  if (invalid) {
    message = t('carbon.progress-step.invalid');
  }

  return /*#__PURE__*/React.createElement("li", {
    className: classes
  }, /*#__PURE__*/React.createElement("button", _extends({
    type: "button",
    className: classnames("".concat(prefix, "--progress-step-button"), _defineProperty({}, "".concat(prefix, "--progress-step-button--unclickable"), !onClick || current)),
    disabled: disabled,
    "aria-disabled": disabled,
    tabIndex: !current && onClick && !disabled ? 0 : -1,
    onClick: !current ? onClick : undefined,
    onKeyDown: handleKeyDown,
    title: label
  }, rest), /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--assistive-text")
  }, message), /*#__PURE__*/React.createElement(SVGIcon, {
    complete: complete,
    current: current,
    description: description,
    invalid: invalid,
    prefix: prefix
  }), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--progress-text")
  }, /*#__PURE__*/React.createElement(ProgressStepLabel, {
    className: "".concat(prefix, "--progress-label")
  }, label), secondaryLabel !== null && secondaryLabel !== undefined ? /*#__PURE__*/React.createElement("p", {
    className: "".concat(prefix, "--progress-optional")
  }, secondaryLabel) : null), /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--progress-line")
  })));
}
ProgressStep.propTypes = {
  /**
   * Provide an optional className to be applied to the containing `<li>` node
   */
  className: PropTypes.string,

  /**
   * Specify whether the step has been completed
   */
  complete: PropTypes.bool,

  /**
   * Specify whether the step is the current step
   */
  current: PropTypes.bool,

  /**
   * Provide a description for the <ProgressStep>
   */
  description: PropTypes.string,

  /**
   * Specify whether the step is disabled
   */
  disabled: PropTypes.bool,

  /**
   * Index of the current step within the ProgressIndicator
   */
  index: PropTypes.number,

  /**
   * Specify whether the step is invalid
   */
  invalid: PropTypes.bool,

  /**
   * Provide the label for the <ProgressStep>
   */
  label: PropTypes.node.isRequired,

  /**
   * A callback called if the step is clicked or the enter key is pressed
   */
  onClick: PropTypes.func,

  /**
   * Provide the props that describe a progress step tooltip
   */
  overflowTooltipProps: PropTypes.object,

  /*
   * An optional parameter to allow for overflow content to be rendered in a
   * tooltip.
   */
  renderLabel: PropTypes.func,

  /**
   * Provide an optional secondary label
   */
  secondaryLabel: PropTypes.string,

  /**
   * The ID of the tooltip content.
   */
  tooltipId: PropTypes.string,

  /**
   * Optional method that takes in a message id and returns an
   * internationalized string.
   */
  translateWithId: PropTypes.func
};
ProgressStep.defaultProps = {
  renderLabel: defaultRenderLabel,
  translateWithId: translateWithId
};
export var ProgressIndicator = /*#__PURE__*/function (_Component) {
  _inherits(ProgressIndicator, _Component);

  var _super = _createSuper(ProgressIndicator);

  function ProgressIndicator() {
    var _this;

    _classCallCheck(this, ProgressIndicator);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {});

    _defineProperty(_assertThisInitialized(_this), "renderSteps", function () {
      var onChange = _this.props.onChange;
      return React.Children.map(_this.props.children, function (child, index) {
        // only setup click handlers if onChange event is passed
        var onClick = onChange ? function () {
          return onChange(index);
        } : undefined;

        if (index === _this.state.currentIndex) {
          return /*#__PURE__*/React.cloneElement(child, {
            current: true,
            index: index,
            onClick: onClick
          });
        }

        if (index < _this.state.currentIndex) {
          return /*#__PURE__*/React.cloneElement(child, {
            complete: true,
            index: index,
            onClick: onClick
          });
        }

        if (index > _this.state.currentIndex) {
          return /*#__PURE__*/React.cloneElement(child, {
            complete: child.props.complete || false,
            index: index,
            onClick: onClick
          });
        }

        return null;
      });
    });

    return _this;
  }

  _createClass(ProgressIndicator, [{
    key: "render",
    value: function render() {
      var _classnames3;

      var _this$props = this.props,
          className = _this$props.className,
          currentIndex = _this$props.currentIndex,
          vertical = _this$props.vertical,
          spaceEqually = _this$props.spaceEqually,
          other = _objectWithoutProperties(_this$props, _excluded2);

      var prefix = this.context;
      var classes = classnames((_classnames3 = {}, _defineProperty(_classnames3, "".concat(prefix, "--progress"), true), _defineProperty(_classnames3, "".concat(prefix, "--progress--vertical"), vertical), _defineProperty(_classnames3, "".concat(prefix, "--progress--space-equal"), spaceEqually && !vertical), _defineProperty(_classnames3, className, className), _classnames3));
      return /*#__PURE__*/React.createElement("ul", _extends({
        className: classes
      }, other), this.renderSteps());
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(_ref3, state) {
      var currentIndex = _ref3.currentIndex;
      var prevCurrentIndex = state.prevCurrentIndex;
      return prevCurrentIndex === currentIndex ? null : {
        currentIndex: currentIndex,
        prevCurrentIndex: currentIndex
      };
    }
  }]);

  return ProgressIndicator;
}(Component);

_defineProperty(ProgressIndicator, "propTypes", {
  /**
   * Provide <ProgressStep> components to be rendered in the
   * <ProgressIndicator>
   */
  children: PropTypes.node,

  /**
   * Provide an optional className to be applied to the containing node
   */
  className: PropTypes.string,

  /**
   * Optionally specify the current step array index
   */
  currentIndex: PropTypes.number,

  /**
   * Optional callback called if a ProgressStep is clicked on.  Returns the index of the step.
   */
  onChange: PropTypes.func,

  /**
   * Specify whether the progress steps should be split equally in size in the div
   */
  spaceEqually: PropTypes.bool,

  /**
   * Determines whether or not the ProgressIndicator should be rendered vertically.
   */
  vertical: PropTypes.bool
});

_defineProperty(ProgressIndicator, "contextType", PrefixContext);

_defineProperty(ProgressIndicator, "defaultProps", {
  currentIndex: 0
});