/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { ProgressIndicator, ProgressStep, ProgressIndicatorSkeleton } from '../';
import Tooltip from '../../Tooltip';
export default {
  title: 'Components/ProgressIndicator'
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(ProgressIndicator, null, /*#__PURE__*/React.createElement(ProgressStep, {
    label: "First step",
    description: "Step 1: Getting started with Carbon Design System",
    secondaryLabel: "Optional label"
  }), /*#__PURE__*/React.createElement(ProgressStep, {
    label: "Second step with tooltip",
    description: "Step 2: Getting started with Carbon Design System",
    renderLabel: function renderLabel() {
      return /*#__PURE__*/React.createElement(Tooltip, {
        direction: "bottom",
        showIcon: false,
        triggerClassName: "bx--progress-label",
        triggerText: 'Second step with tooltip',
        tooltipId: "tooltipId-0"
      }, /*#__PURE__*/React.createElement("p", null, "Overflow tooltip content."));
    }
  }), /*#__PURE__*/React.createElement(ProgressStep, {
    label: "Third step with tooltip",
    description: "Step 3: Getting started with Carbon Design System",
    renderLabel: function renderLabel() {
      return /*#__PURE__*/React.createElement(Tooltip, {
        direction: "bottom",
        showIcon: false,
        triggerClassName: "bx--progress-label",
        triggerText: 'Second step with tooltip',
        tooltipId: "tooltipId-0"
      }, /*#__PURE__*/React.createElement("p", null, "Overflow tooltip content."));
    }
  }), /*#__PURE__*/React.createElement(ProgressStep, {
    label: "Fourth step",
    description: "Step 4: Getting started with Carbon Design System",
    invalid: true,
    secondaryLabel: "Example invalid step"
  }), /*#__PURE__*/React.createElement(ProgressStep, {
    label: "Fifth step",
    description: "Step 5: Getting started with Carbon Design System",
    disabled: true
  }));
};
export var Interactive = function Interactive() {
  return /*#__PURE__*/React.createElement(ProgressIndicator, {
    currentIndex: 1,
    onChange: function onChange() {
      return alert('Clicked');
    }
  }, /*#__PURE__*/React.createElement(ProgressStep, {
    label: "Click me",
    description: "Step 1: Register a onChange event"
  }), /*#__PURE__*/React.createElement(ProgressStep, {
    label: "Really long label",
    description: "The progress indicator will listen for clicks on the steps"
  }), /*#__PURE__*/React.createElement(ProgressStep, {
    label: "Tooltip and really long label",
    description: "The progress indicator will listen for clicks on the steps",
    renderLabel: function renderLabel() {
      return /*#__PURE__*/React.createElement(Tooltip, {
        direction: "bottom",
        showIcon: false,
        triggerClassName: "bx--progress-label",
        triggerText: "Tooltip and really long label",
        tooltipId: "tooltipId-1"
      }, /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor, sit amet consectetur adipisicing elit. Animi consequuntur hic ratione aliquid cupiditate, nesciunt saepe iste blanditiis cumque maxime tenetur veniam est illo deserunt sint quae pariatur. Laboriosam, consequatur."));
    }
  }));
};
export var Skeleton = function Skeleton() {
  return /*#__PURE__*/React.createElement(ProgressIndicatorSkeleton, null);
};