import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "disabled", "hideLabel", "id", "labelPosition", "labelText", "name", "onChange", "value"];
import PropTypes from 'prop-types';
import React from 'react';
import classNames from 'classnames';
import { usePrefix } from '../../../internal/usePrefix';
import { useId } from '../../../internal/useId';
import { Text } from '../../Text';
var RadioButton = /*#__PURE__*/React.forwardRef(function RadioButton(_ref, ref) {
  var className = _ref.className,
      disabled = _ref.disabled,
      hideLabel = _ref.hideLabel,
      id = _ref.id,
      _ref$labelPosition = _ref.labelPosition,
      labelPosition = _ref$labelPosition === void 0 ? 'right' : _ref$labelPosition,
      _ref$labelText = _ref.labelText,
      labelText = _ref$labelText === void 0 ? '' : _ref$labelText,
      name = _ref.name,
      _ref$onChange = _ref.onChange,
      onChange = _ref$onChange === void 0 ? function () {} : _ref$onChange,
      _ref$value = _ref.value,
      value = _ref$value === void 0 ? '' : _ref$value,
      rest = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  var uid = useId('radio-button');
  var uniqueId = id || uid;

  function handleOnChange(event) {
    onChange(value, name, event);
  }

  var innerLabelClasses = classNames(_defineProperty({}, "".concat(prefix, "--visually-hidden"), hideLabel));
  var wrapperClasses = classNames(className, "".concat(prefix, "--radio-button-wrapper"), _defineProperty({}, "".concat(prefix, "--radio-button-wrapper--label-").concat(labelPosition), labelPosition !== 'right'));
  return /*#__PURE__*/React.createElement("div", {
    className: wrapperClasses
  }, /*#__PURE__*/React.createElement("input", _extends({}, rest, {
    type: "radio",
    className: "".concat(prefix, "--radio-button"),
    onChange: handleOnChange,
    id: uniqueId,
    ref: ref,
    disabled: disabled
  })), /*#__PURE__*/React.createElement("label", {
    htmlFor: uniqueId,
    className: "".concat(prefix, "--radio-button__label")
  }, /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--radio-button__appearance")
  }), labelText && /*#__PURE__*/React.createElement(Text, {
    className: innerLabelClasses
  }, labelText)));
});
RadioButton.propTypes = {
  /**
   * Specify whether the <RadioButton> is currently checked
   */
  checked: PropTypes.bool,

  /**
   * Provide an optional className to be applied to the containing node
   */
  className: PropTypes.string,

  /**
   * Specify whether the <RadioButton> should be checked by default
   */
  defaultChecked: PropTypes.bool,

  /**
   * Specify whether the control is disabled
   */
  disabled: PropTypes.bool,

  /**
   * Specify whether the label should be hidden, or not
   */
  hideLabel: PropTypes.bool,

  /**
   * Provide a unique id for the underlying `<input>` node
   */
  id: PropTypes.string,

  /**
   * Provide where label text should be placed
   * NOTE: `top`/`bottom` are deprecated
   */
  labelPosition: PropTypes.oneOf(['right', 'left']),

  /**
   * Provide label text to be read by screen readers when interacting with the
   * control
   */
  labelText: PropTypes.node.isRequired,

  /**
   * Provide a name for the underlying `<input>` node
   */
  name: PropTypes.string,

  /**
   * Provide an optional `onChange` hook that is called each time the value of
   * the underlying `<input>` changes
   */
  onChange: PropTypes.func,

  /**
   * Provide a handler that is invoked when a user clicks on the control
   */
  onClick: PropTypes.func,

  /**
   * Specify the value of the <RadioButton>
   */
  value: PropTypes.oneOfType([PropTypes.string, PropTypes.number]).isRequired
};
export default RadioButton;