import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { ListBulleted16, Grid16 } from '@carbon/icons-react';
import { settings } from 'carbon-components';
import PropTypes from 'prop-types';
import React, { Component } from 'react';
import { warning } from '../../internal/warning';
var prefix = settings.prefix;
var didWarnAboutDeprecation = false;
/**
 * The layout button for `<Search>`.
 */

var SearchLayoutButton = /*#__PURE__*/function (_Component) {
  _inherits(SearchLayoutButton, _Component);

  var _super = _createSuper(SearchLayoutButton);

  function SearchLayoutButton(props) {
    var _this;

    _classCallCheck(this, SearchLayoutButton);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "state", {
      format: 'list'
    });

    _defineProperty(_assertThisInitialized(_this), "toggleLayout", function () {
      var format = _this.state.format === 'list' ? 'grid' : 'list';

      _this.setState({
        format: format
      }, function () {
        var onChangeFormat = _this.props.onChangeFormat;

        if (typeof onChangeFormat === 'function') {
          onChangeFormat({
            format: format
          });
        }
      });
    });

    if (process.env.NODE_ENV !== "production") {
      process.env.NODE_ENV !== "production" ? warning(didWarnAboutDeprecation, 'The SearchLayoutButton component has been deprecated and will be removed in the next major release of `carbon-components-react`') : void 0;
      didWarnAboutDeprecation = true;
    }

    return _this;
  }
  /**
   * Toggles the button state upon user-initiated event.
   */


  _createClass(SearchLayoutButton, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          labelText = _this$props.labelText,
          iconDescriptionList = _this$props.iconDescriptionList,
          iconDescriptionGrid = _this$props.iconDescriptionGrid;

      var SearchLayoutButtonIcon = function SearchLayoutButtonIcon() {
        if (_this2.state.format === 'list') {
          return /*#__PURE__*/React.createElement(ListBulleted16, {
            className: "".concat(prefix, "--search-view"),
            "aria-label": iconDescriptionList
          });
        }

        return /*#__PURE__*/React.createElement(Grid16, {
          className: "".concat(prefix, "--search-view"),
          "aria-label": iconDescriptionGrid
        });
      };

      return /*#__PURE__*/React.createElement("button", {
        className: "".concat(prefix, "--search-button"),
        type: "button",
        onClick: this.toggleLayout,
        "aria-label": labelText,
        title: labelText
      }, /*#__PURE__*/React.createElement("div", {
        className: "".concat(prefix, "--search__toggle-layout__container")
      }, /*#__PURE__*/React.createElement(SearchLayoutButtonIcon, null)));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(_ref, state) {
      var format = _ref.format;
      var prevFormat = state.prevFormat;
      return prevFormat === format ? null : {
        format: format || 'list',
        prevFormat: format
      };
    }
  }]);

  return SearchLayoutButton;
}(Component);

_defineProperty(SearchLayoutButton, "propTypes", {
  /**
   * The layout.
   */
  format: PropTypes.oneOf(['list', 'grid']),

  /**
   * The description for the "grid" icon.
   */
  iconDescriptionGrid: PropTypes.string,

  /**
   * The description for the "list" icon.
   */
  iconDescriptionList: PropTypes.string,

  /**
   * The a11y label text.
   */
  labelText: PropTypes.string,

  /**
   * The callback called when layout switches.
   */
  onChangeFormat: PropTypes.func
});

_defineProperty(SearchLayoutButton, "defaultProps", {
  labelText: 'Filter',
  iconDescriptionList: 'list',
  iconDescriptionGrid: 'grid'
});

export default SearchLayoutButton;