import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "value", "disabled", "hidden", "text"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import classNames from 'classnames';
import { settings } from 'carbon-components';
var prefix = settings.prefix;

var SelectItem = function SelectItem(_ref) {
  var _classNames;

  var className = _ref.className,
      value = _ref.value,
      disabled = _ref.disabled,
      hidden = _ref.hidden,
      text = _ref.text,
      other = _objectWithoutProperties(_ref, _excluded);

  var selectItemClasses = classNames((_classNames = {}, _defineProperty(_classNames, "".concat(prefix, "--select-option"), true), _defineProperty(_classNames, className, className), _classNames));
  return /*#__PURE__*/React.createElement("option", _extends({}, other, {
    className: selectItemClasses,
    value: value,
    disabled: disabled,
    hidden: hidden
  }), text);
};

SelectItem.propTypes = {
  /**
   * Specify an optional className to be applied to the node
   */
  className: PropTypes.string,

  /**
   * Specify whether the <SelectItem> should be disabled
   */
  disabled: PropTypes.bool,

  /**
   * Specify whether the <SelectItem> is hidden
   */
  hidden: PropTypes.bool,

  /**
   * Provide the contents of your <SelectItem>
   */
  text: PropTypes.string.isRequired,

  /**
   * Specify the value of the <SelectItem>
   */
  value: PropTypes.any.isRequired
};
SelectItem.defaultProps = {
  disabled: false,
  hidden: false,
  value: '',
  text: ''
};
export default SelectItem;