/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import SkeletonText from '../../SkeletonText';
import SkeletonPlaceholder from '../../SkeletonPlaceholder';
import { withKnobs, select, boolean, number } from '@storybook/addon-knobs';
var classNames = {
  'my--skeleton__placeholder--small': 'my--skeleton__placeholder--small',
  'my--skeleton__placeholder--medium': 'my--skeleton__placeholder--medium',
  'my--skeleton__placeholder--large': 'my--skeleton__placeholder--large'
};

var placeholderProps = function placeholderProps() {
  return {
    className: select('Classes with different sizes', classNames)
  };
};

var widths = {
  '100%': '100%',
  '250px': '250px'
};

var textProps = function textProps() {
  return {
    heading: boolean('Skeleton text at a larger size (heading)'),
    paragraph: boolean('Use multiple lines of text (paragraph)'),
    lineCount: number('The number of lines in a paragraph (lineCount)', 3),
    width: select('Width (in px or %) of single line of text or max-width of paragraph lines (width)', widths, '100%')
  };
};

export default {
  title: 'Components/Skeleton',
  decorators: [withKnobs]
};
export var _SkeletonPlaceholder = function _SkeletonPlaceholder() {
  return /*#__PURE__*/React.createElement("div", {
    style: {
      height: '250px',
      width: '250px'
    }
  }, /*#__PURE__*/React.createElement("style", {
    dangerouslySetInnerHTML: {
      __html: "\n      .my--skeleton__placeholder--small {\n        height: 100px;\n        width: 100px;\n      }\n\n      .my--skeleton__placeholder--medium {\n        height: 150px;\n        width: 150px;\n      }\n\n      .my--skeleton__placeholder--large {\n        height: 250px;\n        width: 250px;\n      }\n    "
    }
  }), /*#__PURE__*/React.createElement(SkeletonPlaceholder, placeholderProps()));
};
export var _SkeletonText = function _SkeletonText() {
  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: '300px'
    }
  }, /*#__PURE__*/React.createElement(SkeletonText, textProps()));
};