import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { usePrefix } from '../../internal/usePrefix';

var SkeletonPlaceholder = function SkeletonPlaceholder(_ref) {
  var _classNames;

  var className = _ref.className,
      other = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  var skeletonPlaceholderClasses = classNames((_classNames = {}, _defineProperty(_classNames, "".concat(prefix, "--skeleton__placeholder"), true), _defineProperty(_classNames, className, className), _classNames));
  return /*#__PURE__*/React.createElement("div", _extends({
    className: skeletonPlaceholderClasses
  }, other));
};

SkeletonPlaceholder.propTypes = {
  /**
   * the class to be applied to the component
   */
  className: PropTypes.string
};
export default SkeletonPlaceholder;