/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import 'carbon-components/scss/components/tabs/_tabs.scss';
import React from 'react';
import { mount } from '@cypress/react';
import Tabs from './Tabs';
import Tab from '../Tab/Tab';
import TabsSkeleton from './Tabs.Skeleton';
describe('Tabs', function () {
  beforeEach(function () {
    mount( /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Tabs, null, /*#__PURE__*/React.createElement(Tab, {
      label: "Tab label 1"
    }, /*#__PURE__*/React.createElement("p", null, "Content for first tab goes here.")), /*#__PURE__*/React.createElement(Tab, {
      label: "Tab label 2"
    }, /*#__PURE__*/React.createElement("p", null, "Content for second tab goes here.")), /*#__PURE__*/React.createElement(Tab, {
      label: "Tab label 3",
      disabled: true
    }, /*#__PURE__*/React.createElement("p", null, "Content for third tab goes here.")), /*#__PURE__*/React.createElement(Tab, {
      label: "Tab label 4 shows truncation",
      title: "Tab label 4 shows truncation"
    }, /*#__PURE__*/React.createElement("p", null, "Content for fourth tab goes here."))), /*#__PURE__*/React.createElement(Tabs, {
      type: "container"
    }, /*#__PURE__*/React.createElement(Tab, {
      label: "Tab label 1"
    }, /*#__PURE__*/React.createElement("p", null, "Yellow")), /*#__PURE__*/React.createElement(Tab, {
      label: "Tab label 2"
    }, /*#__PURE__*/React.createElement("p", null, "Content for second tab goes here.")), /*#__PURE__*/React.createElement(Tab, {
      label: "Tab label 3 shows truncation",
      title: "Tab label 3 shows truncation"
    }, /*#__PURE__*/React.createElement("p", null, "Content for third tab goes here.")), /*#__PURE__*/React.createElement(Tab, {
      label: "Tab label 4",
      disabled: true
    }, /*#__PURE__*/React.createElement("p", null, "Content for fourth container tab goes here."))), /*#__PURE__*/React.createElement(TabsSkeleton, {
      type: "default"
    }), /*#__PURE__*/React.createElement(TabsSkeleton, {
      type: "container"
    })));
  });
  it('should render', function () {
    cy.findByText('Yellow').should('be.visible'); // snapshots should always be taken _after_ an assertion that
    // a element/component should be visible. This is to ensure
    // the DOM has settled and the element has fully loaded.

    cy.percySnapshot();
  });
});