import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { withKnobs, select, text, boolean } from '@storybook/addon-knobs';
import { Carbon16, Compass16, Tag16 } from '@carbon/icons-react';
import Tag, { types as typesList } from '../Tag';
import TagSkeleton from '../Tag/Tag.Skeleton';
import { action } from '@storybook/addon-actions';
import mdx from './Tag.mdx';
var icons = {
  'Carbon (Carbon16 from `@carbon/icons-react`)': 'Carbon16',
  'Compass (Compass16 from `@carbon/icons-react`)': 'Compass16',
  'Tag (Tag16 from `@carbon/icons-react`)': 'Tag16'
};
var iconMap = {
  Carbon16: Carbon16,
  Compass16: Compass16,
  Tag16: Tag16
};
var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined
};
var props = {
  regular: function regular() {
    return {
      type: select('Tag type (type)', typesList.reduce(function (acc, type) {
        return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, "".concat(type, " (").concat(type, ")"), type));
      }, {
        Default: undefined
      })),
      disabled: boolean('Disabled (disabled)', false),
      size: select('Field size (size)', sizes, undefined) || undefined,
      title: text('Title (title)', 'Clear Filter')
    };
  },
  filter: function filter() {
    return _objectSpread(_objectSpread({}, this.regular()), {}, {
      onClick: action('onClick'),
      onClose: action('onClose')
    });
  },
  icon: function icon() {
    return _objectSpread(_objectSpread({}, this.regular()), {}, {
      renderIcon: iconMap[select('Icon (icon)', icons, 'Tag16')]
    });
  }
};
export default {
  title: 'Components/Tag',
  decorators: [withKnobs],
  parameters: {
    component: Tag,
    docs: {
      page: mdx
    },
    subcomponents: {
      TagSkeleton: TagSkeleton
    }
  }
};
export var _Default = function _Default() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Tag, _extends({
    className: "some-class"
  }, props.regular()), text('Content (children)', 'This is a tag')), /*#__PURE__*/React.createElement(Tag, _extends({
    className: "some-class"
  }, props.regular(), {
    onClick: action('onClick')
  }), "This is an interactive tag"));
};
_Default.parameters = {
  info: {
    text: "\n        Tags are used for items that need to be labeled, categorized, or organized using keywords that describe them.\n        The example below shows how the Tag component can be used. Each type has a default message describing the type,\n        but a custom message can also be applied.\n      "
  }
};
export var Filter = function Filter() {
  return /*#__PURE__*/React.createElement(Tag, _extends({
    className: "some-class"
  }, props.filter(), {
    filter: true
  }), text('Content (children)', 'This is a tag'));
};
Filter.parameters = {
  info: {
    text: "\n        Tags are used for items that need to be labeled, categorized, or organized using keywords that describe them.\n        The example below shows how the Tag component can be used. Each type has a default message describing the type,\n        but a custom message can also be applied.\n      "
  }
};
export var CustomIcon = function CustomIcon() {
  return /*#__PURE__*/React.createElement(Tag, _extends({
    className: "some-class"
  }, props.icon()), text('Content (children)', 'This is a tag'));
};
CustomIcon.parameters = {
  info: {
    text: "\n        Tags are used for items that need to be labeled, categorized, or organized using keywords that describe them.\n        The example below shows how the Tag component can be used. Each type has a default message describing the type,\n        but a custom message can also be applied.\n      "
  }
};
export var Skeleton = function Skeleton() {
  return /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(TagSkeleton, null), /*#__PURE__*/React.createElement(TagSkeleton, {
    size: "sm"
  }));
};
Skeleton.storyName = 'skeleton';
Skeleton.parameters = {
  info: {
    text: "\n      Placeholder skeleton state to use when content is loading.\n      "
  }
};