import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["labelText", "className", "id", "placeholder", "type", "onChange", "onClick", "hideLabel", "disabled", "invalid", "invalidText", "warn", "warnText", "helperText", "light", "size", "inline", "readOnly"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React, { useContext } from 'react';
import classNames from 'classnames';
import { useNormalizedInputProps } from '../../internal/useNormalizedInputProps';
import PasswordInput from './PasswordInput';
import ControlledPasswordInput from './ControlledPasswordInput';
import { textInputProps } from './util';
import { FormContext } from '../FluidForm';
import { useFeatureFlag } from '../FeatureFlags';
import { usePrefix } from '../../internal/usePrefix';
var TextInput = /*#__PURE__*/React.forwardRef(function TextInput(_ref, ref) {
  var _classNames, _classNames2, _classNames3, _classNames4, _classNames7;

  var labelText = _ref.labelText,
      className = _ref.className,
      id = _ref.id,
      placeholder = _ref.placeholder,
      type = _ref.type,
      _onChange = _ref.onChange,
      _onClick = _ref.onClick,
      hideLabel = _ref.hideLabel,
      disabled = _ref.disabled,
      invalid = _ref.invalid,
      invalidText = _ref.invalidText,
      warn = _ref.warn,
      warnText = _ref.warnText,
      helperText = _ref.helperText,
      light = _ref.light,
      size = _ref.size,
      inline = _ref.inline,
      readOnly = _ref.readOnly,
      other = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  var enabled = useFeatureFlag('enable-v11-release');
  var normalizedProps = useNormalizedInputProps({
    id: id,
    readOnly: readOnly,
    disabled: disabled,
    invalid: invalid,
    invalidText: invalidText,
    warn: warn,
    warnText: warnText
  });
  var customClassName = className !== null && className !== void 0 ? className : "".concat(prefix, "--text__input");
  var textInputClasses = classNames("".concat(prefix, "--text-input"), [enabled ? null : className], (_classNames = {}, _defineProperty(_classNames, customClassName, enabled), _defineProperty(_classNames, "".concat(prefix, "--text-input--light"), light), _defineProperty(_classNames, "".concat(prefix, "--text-input--invalid"), normalizedProps.invalid), _defineProperty(_classNames, "".concat(prefix, "--text-input--warning"), normalizedProps.warn), _defineProperty(_classNames, "".concat(prefix, "--text-input--").concat(size), size), _classNames));

  var sharedTextInputProps = _objectSpread(_defineProperty({
    id: id,
    onChange: function onChange(evt) {
      if (!normalizedProps.disabled) {
        _onChange(evt);
      }
    },
    onClick: function onClick(evt) {
      if (!normalizedProps.disabled) {
        _onClick(evt);
      }
    },
    placeholder: placeholder,
    type: type,
    ref: ref,
    className: textInputClasses,
    title: placeholder,
    disabled: normalizedProps.disabled,
    readOnly: readOnly
  }, 'aria-describedby', helperText && normalizedProps.helperId), other);

  var inputWrapperClasses = classNames([enabled ? classNames("".concat(prefix, "--form-item"), className) : "".concat(prefix, "--form-item")], "".concat(prefix, "--text-input-wrapper"), (_classNames2 = {}, _defineProperty(_classNames2, "".concat(prefix, "--text-input-wrapper--readonly"), readOnly), _defineProperty(_classNames2, "".concat(prefix, "--text-input-wrapper--light"), light), _defineProperty(_classNames2, "".concat(prefix, "--text-input-wrapper--inline"), inline), _classNames2));
  var labelClasses = classNames("".concat(prefix, "--label"), (_classNames3 = {}, _defineProperty(_classNames3, "".concat(prefix, "--visually-hidden"), hideLabel), _defineProperty(_classNames3, "".concat(prefix, "--label--disabled"), normalizedProps.disabled), _defineProperty(_classNames3, "".concat(prefix, "--label--inline"), inline), _defineProperty(_classNames3, "".concat(prefix, "--label--inline--").concat(size), inline && !!size), _classNames3));
  var helperTextClasses = classNames("".concat(prefix, "--form__helper-text"), (_classNames4 = {}, _defineProperty(_classNames4, "".concat(prefix, "--form__helper-text--disabled"), normalizedProps.disabled), _defineProperty(_classNames4, "".concat(prefix, "--form__helper-text--inline"), inline), _classNames4));
  var fieldOuterWrapperClasses = classNames("".concat(prefix, "--text-input__field-outer-wrapper"), _defineProperty({}, "".concat(prefix, "--text-input__field-outer-wrapper--inline"), inline));
  var fieldWrapperClasses = classNames("".concat(prefix, "--text-input__field-wrapper"), _defineProperty({}, "".concat(prefix, "--text-input__field-wrapper--warning"), normalizedProps.warn));
  var iconClasses = classNames((_classNames7 = {}, _defineProperty(_classNames7, "".concat(prefix, "--text-input__invalid-icon"), normalizedProps.invalid || normalizedProps.warn), _defineProperty(_classNames7, "".concat(prefix, "--text-input__invalid-icon--warning"), normalizedProps.warn), _defineProperty(_classNames7, "".concat(prefix, "--text-input__readonly-icon"), readOnly), _classNames7));
  var label = labelText ? /*#__PURE__*/React.createElement("label", {
    htmlFor: id,
    className: labelClasses
  }, labelText) : null;
  var helper = helperText ? /*#__PURE__*/React.createElement("div", {
    id: normalizedProps.helperId,
    className: helperTextClasses
  }, helperText) : null;
  var input = /*#__PURE__*/React.createElement("input", textInputProps({
    sharedTextInputProps: sharedTextInputProps,
    invalid: normalizedProps.invalid,
    invalidId: normalizedProps.invalidId,
    warn: normalizedProps.warn,
    warnId: normalizedProps.warnId
  }));

  var _useContext = useContext(FormContext),
      isFluid = _useContext.isFluid;

  return /*#__PURE__*/React.createElement("div", {
    className: inputWrapperClasses
  }, !inline ? label : /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--text-input__label-helper-wrapper")
  }, label, !isFluid && helper), /*#__PURE__*/React.createElement("div", {
    className: fieldOuterWrapperClasses
  }, /*#__PURE__*/React.createElement("div", {
    className: fieldWrapperClasses,
    "data-invalid": normalizedProps.invalid || null
  }, normalizedProps.icon && /*#__PURE__*/React.createElement(normalizedProps.icon, {
    className: iconClasses
  }), input, isFluid && /*#__PURE__*/React.createElement("hr", {
    className: "".concat(prefix, "--text-input__divider")
  }), isFluid && !inline && normalizedProps.validation), !isFluid && !inline && (normalizedProps.validation || helper)));
});
TextInput.displayName = 'TextInput';
TextInput.PasswordInput = PasswordInput;
TextInput.ControlledPasswordInput = ControlledPasswordInput;
TextInput.propTypes = {
  /**
   * Specify an optional className to be applied to the `<input>` node
   */
  className: PropTypes.string,

  /**
   * Optionally provide the default value of the `<input>`
   */
  defaultValue: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),

  /**
   * Specify whether the `<input>` should be disabled
   */
  disabled: PropTypes.bool,

  /**
   * Provide text that is used alongside the control label for additional help
   */
  helperText: PropTypes.node,

  /**
   * Specify whether you want the underlying label to be visually hidden
   */
  hideLabel: PropTypes.bool,

  /**
   * Specify a custom `id` for the `<input>`
   */
  id: PropTypes.string.isRequired,

  /**
   * `true` to use the inline version.
   */
  inline: PropTypes.bool,

  /**
   * Specify whether the control is currently invalid
   */
  invalid: PropTypes.bool,

  /**
   * Provide the text that is displayed when the control is in an invalid state
   */
  invalidText: PropTypes.node,

  /**
   * Provide the text that will be read by a screen reader when visiting this
   * control
   */
  labelText: PropTypes.node.isRequired,

  /**
   * `true` to use the light version. For use on $ui-01 backgrounds only.
   * Don't use this to make tile background color same as container background color.
   */
  light: PropTypes.bool,

  /**
   * Optionally provide an `onChange` handler that is called whenever `<input>`
   * is updated
   */
  onChange: PropTypes.func,

  /**
   * Optionally provide an `onClick` handler that is called whenever the
   * `<input>` is clicked
   */
  onClick: PropTypes.func,

  /**
   * Specify the placeholder attribute for the `<input>`
   */
  placeholder: PropTypes.string,

  /**
   * Whether the input should be read-only
   */
  readOnly: PropTypes.bool,

  /**
   * Specify the size of the Text Input. Currently supports either `sm`, 'md' (default) or 'lg` as an option.
   * TODO V11: remove `xl` (replaced with lg)
   */
  size: PropTypes.oneOf(['sm', 'md', 'lg', 'xl']),

  /**
   * Specify the type of the `<input>`
   */
  type: PropTypes.string,

  /**
   * Specify the value of the `<input>`
   */
  value: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),

  /**
   * Specify whether the control is currently in warning state
   */
  warn: PropTypes.bool,

  /**
   * Provide the text that is displayed when the control is in warning state
   */
  warnText: PropTypes.node
};
TextInput.defaultProps = {
  disabled: false,
  type: 'text',
  onChange: function onChange() {},
  onClick: function onClick() {},
  invalid: false,
  invalidText: '',
  warn: false,
  warnText: '',
  helperText: '',
  light: false,
  inline: false
};
export default TextInput;