/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import FluidForm from '../../FluidForm';
import { default as TextInput, TextInputSkeleton } from '../../TextInput';
import { Layer } from '../../Layer';
import mdx from './TextInput.mdx';
export default {
  title: 'Components/TextInput',
  parameters: {
    component: TextInput,
    docs: {
      page: mdx
    },
    subcomponents: {
      TextInputSkeleton: TextInputSkeleton,
      'TextInput.PasswordInput': TextInput.PasswordInput
    }
  }
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(TextInput, {
    type: "text",
    labelText: "Text input label",
    defaultValue: "This is not a default value",
    helperText: "Optional help text"
  });
};
export var Fluid = function Fluid() {
  return /*#__PURE__*/React.createElement(FluidForm, null, /*#__PURE__*/React.createElement(TextInput, {
    type: "text",
    labelText: "Text input label",
    defaultValue: "This is not a default value"
  }));
};
export var TogglePasswordVisibility = function TogglePasswordVisibility() {
  return /*#__PURE__*/React.createElement(TextInput.PasswordInput, {
    labelText: "Text input label",
    defaultValue: "This is not a default value",
    helperText: "Optional help text"
  });
};
export var withLayer = function withLayer() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(TextInput, {
    type: "text",
    labelText: "First layer",
    defaultValue: "This is not a default value",
    helperText: "Optional help text"
  }), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(TextInput, {
    type: "text",
    labelText: "Second layer",
    defaultValue: "This is not a default value",
    helperText: "Optional help text"
  }), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(TextInput, {
    type: "text",
    labelText: "Third layer",
    defaultValue: "This is not a default value",
    helperText: "Optional help text"
  }))));
};
export var Skeleton = function Skeleton() {
  return /*#__PURE__*/React.createElement(TextInputSkeleton, null);
};