import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["as", "children", "className", "theme"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import { usePrefix } from '../../internal/usePrefix';
import { LayerContext } from '../Layer/LayerContext';
export var ThemeContext = /*#__PURE__*/React.createContext({
  theme: 'white'
});
/**
 * Specify the theme to be applied to a page, or a region in a page
 */

export function Theme(_ref) {
  var _cx;

  var _ref$as = _ref.as,
      BaseComponent = _ref$as === void 0 ? 'div' : _ref$as,
      children = _ref.children,
      customClassName = _ref.className,
      theme = _ref.theme,
      rest = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  var className = cx(customClassName, (_cx = {}, _defineProperty(_cx, "".concat(prefix, "--white"), theme === 'white'), _defineProperty(_cx, "".concat(prefix, "--g10"), theme === 'g10'), _defineProperty(_cx, "".concat(prefix, "--g90"), theme === 'g90'), _defineProperty(_cx, "".concat(prefix, "--g100"), theme === 'g100'), _defineProperty(_cx, "".concat(prefix, "--layer-one"), true), _cx));
  var value = React.useMemo(function () {
    return {
      theme: theme
    };
  }, [theme]);
  return /*#__PURE__*/React.createElement(ThemeContext.Provider, {
    value: value
  }, /*#__PURE__*/React.createElement(LayerContext.Provider, {
    value: 1
  }, /*#__PURE__*/React.createElement(BaseComponent, _extends({}, rest, {
    className: className
  }), children)));
}
Theme.propTypes = {
  /**
   * Specify a custom component or element to be rendered as the top-level
   * element in the component
   */
  as: PropTypes.oneOfType([PropTypes.func, PropTypes.string, PropTypes.elementType]),

  /**
   * Provide child elements to be rendered inside of `Theme`
   */
  children: PropTypes.node,

  /**
   * Provide a custom class name to be used on the outermost element rendered by
   * the component
   */
  className: PropTypes.string,

  /**
   * Specify the theme
   */
  theme: PropTypes.oneOf(['white', 'g10', 'g90', 'g100'])
};
/**
 * Get access to the current theme
 */

export function useTheme() {
  return React.useContext(ThemeContext);
}