import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["children", "className", "light"],
    _excluded2 = ["children", "href", "className", "handleClick", "handleKeyDown", "onClick", "onKeyDown", "clicked", "light"],
    _excluded3 = ["children", "id", "tabIndex", "value", "name", "title", "iconDescription", "className", "handleClick", "handleKeyDown", "onClick", "onChange", "onKeyDown", "light", "disabled", "selected"],
    _excluded4 = ["tabIndex", "className", "expanded", "tileMaxHeight", "tilePadding", "handleClick", "onClick", "onKeyUp", "tileCollapsedIconText", "tileExpandedIconText", "tileCollapsedLabel", "tileExpandedLabel", "onBeforeClick", "light"];

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { Component, useEffect, useRef, useState } from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import Link from '../Link';
import { Checkbox16, CheckboxCheckedFilled16, ChevronDown16 } from '@carbon/icons-react';
import { keys, matches } from '../../internal/keyboard';
import deprecate from '../../prop-types/deprecate';
import { composeEventHandlers } from '../../tools/events';
import { PrefixContext, usePrefix } from '../../internal/usePrefix';
export var Tile = /*#__PURE__*/function (_Component) {
  _inherits(Tile, _Component);

  var _super = _createSuper(Tile);

  function Tile() {
    _classCallCheck(this, Tile);

    return _super.apply(this, arguments);
  }

  _createClass(Tile, [{
    key: "render",
    value: function render() {
      var prefix = this.context;

      var _this$props = this.props,
          children = _this$props.children,
          className = _this$props.className,
          light = _this$props.light,
          rest = _objectWithoutProperties(_this$props, _excluded);

      var tileClasses = cx("".concat(prefix, "--tile"), _defineProperty({}, "".concat(prefix, "--tile--light"), light), className);
      return /*#__PURE__*/React.createElement("div", _extends({
        className: tileClasses
      }, rest), children);
    }
  }]);

  return Tile;
}(Component);

_defineProperty(Tile, "propTypes", {
  /**
   * The child nodes.
   */
  children: PropTypes.node,

  /**
   * The CSS class names.
   */
  className: PropTypes.string,

  /**
   * `true` to use the light version. For use on $ui-01 backgrounds only.
   * Don't use this to make tile background color same as container background color.
   */
  light: PropTypes.bool
});

_defineProperty(Tile, "contextType", PrefixContext);

_defineProperty(Tile, "defaultProps", {
  light: false
});

export var ClickableTile = /*#__PURE__*/function (_Component2) {
  _inherits(ClickableTile, _Component2);

  var _super2 = _createSuper(ClickableTile);

  function ClickableTile() {
    var _this;

    _classCallCheck(this, ClickableTile);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super2.call.apply(_super2, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {});

    _defineProperty(_assertThisInitialized(_this), "handleClick", function (evt) {
      evt.persist();

      _this.setState({
        clicked: !_this.state.clicked
      }, function () {
        var _this$props$handleCli, _this$props2, _this$props$onClick, _this$props3;

        // TODO: Remove handleClick prop when handleClick is deprecated
        ((_this$props$handleCli = (_this$props2 = _this.props).handleClick) === null || _this$props$handleCli === void 0 ? void 0 : _this$props$handleCli.call(_this$props2, evt)) || ((_this$props$onClick = (_this$props3 = _this.props).onClick) === null || _this$props$onClick === void 0 ? void 0 : _this$props$onClick.call(_this$props3, evt));
      });
    });

    _defineProperty(_assertThisInitialized(_this), "handleKeyDown", function (evt) {
      evt.persist();

      if (matches(evt, [keys.Enter, keys.Space])) {
        _this.setState({
          clicked: !_this.state.clicked
        }, function () {
          var _this$props$handleKey, _this$props4;

          // TODO: Remove handleKeyDown prop when handleKeyDown is deprecated
          ((_this$props$handleKey = (_this$props4 = _this.props).handleKeyDown) === null || _this$props$handleKey === void 0 ? void 0 : _this$props$handleKey.call(_this$props4, evt)) || _this.props.onKeyDown(evt);
        });
      } else {
        var _this$props$handleKey2, _this$props5;

        // TODO: Remove handleKeyDown prop when handleKeyDown is deprecated
        ((_this$props$handleKey2 = (_this$props5 = _this.props).handleKeyDown) === null || _this$props$handleKey2 === void 0 ? void 0 : _this$props$handleKey2.call(_this$props5, evt)) || _this.props.onKeyDown(evt);
      }
    });

    return _this;
  }

  _createClass(ClickableTile, [{
    key: "render",
    value: function render() {
      var _cx2;

      var prefix = this.context;

      var _this$props6 = this.props,
          children = _this$props6.children,
          href = _this$props6.href,
          className = _this$props6.className,
          handleClick = _this$props6.handleClick,
          handleKeyDown = _this$props6.handleKeyDown,
          onClick = _this$props6.onClick,
          onKeyDown = _this$props6.onKeyDown,
          clicked = _this$props6.clicked,
          light = _this$props6.light,
          rest = _objectWithoutProperties(_this$props6, _excluded2);

      var classes = cx("".concat(prefix, "--tile"), "".concat(prefix, "--tile--clickable"), (_cx2 = {}, _defineProperty(_cx2, "".concat(prefix, "--tile--is-clicked"), this.state.clicked), _defineProperty(_cx2, "".concat(prefix, "--tile--light"), light), _cx2), className);
      return /*#__PURE__*/React.createElement(Link, _extends({
        href: href,
        className: classes
      }, rest, {
        onClick: this.handleClick,
        onKeyDown: this.handleKeyDown
      }), children);
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: // eslint-disable-next-line react/prop-types
    function getDerivedStateFromProps(_ref, state) {
      var clicked = _ref.clicked;
      var prevClicked = state.prevClicked;
      return prevClicked === clicked ? null : {
        clicked: clicked,
        prevClicked: clicked
      };
    }
  }]);

  return ClickableTile;
}(Component);

_defineProperty(ClickableTile, "propTypes", {
  /**
   * The child nodes.
   */
  children: PropTypes.node,

  /**
   * The CSS class names.
   */
  className: PropTypes.string,

  /**
   * Deprecated in v11. Use 'onClick' instead.
   */
  handleClick: deprecate(PropTypes.func, 'The handleClick prop for ClickableTile has been deprecated in favor of onClick. It will be removed in the next major release.'),

  /**
   * Specify the function to run when the ClickableTile is interacted with via a keyboard
   */
  handleKeyDown: deprecate(PropTypes.func, 'The handleKeyDown prop for ClickableTile has been deprecated in favor of onKeyDown. It will be removed in the next major release.'),

  /**
   * The href for the link.
   */
  href: PropTypes.string,

  /**
   * `true` to use the light version. For use on $ui-01 backgrounds only.
   * Don't use this to make tile background color same as container background color.
   */
  light: PropTypes.bool,

  /**
   * Specify the function to run when the ClickableTile is clicked
   */
  onClick: PropTypes.func,

  /**
   * Specify the function to run when the ClickableTile is interacted with via a keyboard
   */
  onKeyDown: PropTypes.func,

  /**
   * The rel property for the link.
   */
  rel: PropTypes.string
});

_defineProperty(ClickableTile, "contextType", PrefixContext);

_defineProperty(ClickableTile, "defaultProps", {
  clicked: false,
  onClick: function onClick() {},
  onKeyDown: function onKeyDown() {},
  light: false
});

export function SelectableTile(props) {
  var _cx3;

  var children = props.children,
      id = props.id,
      tabIndex = props.tabIndex,
      value = props.value,
      name = props.name,
      title = props.title,
      iconDescription = props.iconDescription,
      className = props.className,
      handleClick = props.handleClick,
      handleKeyDown = props.handleKeyDown,
      onClick = props.onClick,
      onChange = props.onChange,
      onKeyDown = props.onKeyDown,
      light = props.light,
      disabled = props.disabled,
      selected = props.selected,
      rest = _objectWithoutProperties(props, _excluded3);

  var prefix = usePrefix(); // TODO: replace with onClick when handleClick prop is deprecated

  var clickHandler = handleClick || onClick; // TODO: replace with onKeyDown when handleKeyDown prop is deprecated

  var keyDownHandler = handleKeyDown || onKeyDown;

  var _useState = useState(selected),
      _useState2 = _slicedToArray(_useState, 2),
      isSelected = _useState2[0],
      setIsSelected = _useState2[1];

  var input = useRef(null);
  var classes = cx("".concat(prefix, "--tile"), "".concat(prefix, "--tile--selectable"), (_cx3 = {}, _defineProperty(_cx3, "".concat(prefix, "--tile--is-selected"), isSelected), _defineProperty(_cx3, "".concat(prefix, "--tile--light"), light), _defineProperty(_cx3, "".concat(prefix, "--tile--disabled"), disabled), _cx3), className);
  var inputClasses = cx("".concat(prefix, "--tile-input"), _defineProperty({}, "".concat(prefix, "--tile-input--checked"), isSelected)); // TODO: rename to handleClick when handleClick prop is deprecated

  function handleOnClick(evt) {
    evt.preventDefault();
    evt.persist();
    setIsSelected(!isSelected);
    clickHandler(evt);
    onChange(evt);
  } // TODO: rename to handleKeyDown when handleKeyDown prop is deprecated


  function handleOnKeyDown(evt) {
    evt.persist();

    if (matches(evt, [keys.Enter, keys.Space])) {
      evt.preventDefault();
      setIsSelected(!isSelected);
      onChange(evt);
    }

    keyDownHandler(evt);
  }

  function handleChange(event) {
    setIsSelected(event.target.checked);
    onChange(event);
  }

  useEffect(function () {
    setIsSelected(selected);
  }, [selected]);
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("input", {
    ref: input,
    tabIndex: -1,
    id: id,
    className: inputClasses,
    value: value,
    onChange: !disabled ? handleChange : null,
    type: "checkbox",
    disabled: disabled,
    name: name,
    title: title,
    checked: isSelected
  }), /*#__PURE__*/React.createElement("label", _extends({
    htmlFor: id,
    className: classes // eslint-disable-next-line jsx-a11y/no-noninteractive-tabindex
    ,
    tabIndex: !disabled ? tabIndex : null
  }, rest, {
    onClick: !disabled ? handleOnClick : null,
    onKeyDown: !disabled ? handleOnKeyDown : null
  }), /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--tile__checkmark ").concat(prefix, "--tile__checkmark--persistent")
  }, isSelected ? /*#__PURE__*/React.createElement(CheckboxCheckedFilled16, null) : /*#__PURE__*/React.createElement(Checkbox16, null)), /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--tile-content")
  }, children)));
}
SelectableTile.defaultProps = {
  value: 'value',
  title: 'title',
  selected: false,
  tabIndex: 0,
  light: false,
  onClick: function onClick() {},
  onChange: function onChange() {},
  onKeyDown: function onKeyDown() {}
};
SelectableTile.propTypes = {
  /**
   * The child nodes.
   */
  children: PropTypes.node,

  /**
   * The CSS class names.
   */
  className: PropTypes.string,

  /**
   * Specify whether the SelectableTile should be disabled
   */
  disabled: PropTypes.bool,

  /**
   * Specify the function to run when the SelectableTile is clicked
   */
  handleClick: deprecate(PropTypes.func, 'The `handleClick` prop for `SelectableTile` has been deprecated in favor of `onClick`. It will be removed in the next major release.'),

  /**
   * Specify the function to run when the SelectableTile is interacted with via a keyboard
   */
  handleKeyDown: deprecate(PropTypes.func, 'The `handleKeyDown` prop for `SelectableTile` has been deprecated in favor of `onKeyDown`. It will be removed in the next major release.'),

  /**
   * The description of the checkmark icon.
   */
  iconDescription: deprecate(PropTypes.string, 'The `iconDescription` prop for `SelectableTile` is no longer needed and has ' + 'been deprecated. It will be removed in the next major release.'),

  /**
   * The ID of the `<input>`.
   */
  id: PropTypes.string,

  /**
   * `true` to use the light version. For use on $ui-01 backgrounds only.
   * Don't use this to make tile background color same as container background color.
   */
  light: PropTypes.bool,

  /**
   * The `name` of the `<input>`.
   */
  name: PropTypes.string,

  /**
   * The empty handler of the `<input>`.
   */
  onChange: PropTypes.func,

  /**
   * Specify the function to run when the SelectableTile is clicked
   */
  onClick: PropTypes.func,

  /**
   * Specify the function to run when the SelectableTile is interacted with via a keyboard
   */
  onKeyDown: PropTypes.func,

  /**
   * `true` to select this tile.
   */
  selected: PropTypes.bool,

  /**
   * Specify the tab index of the wrapper element
   */
  tabIndex: PropTypes.number,

  /**
   * The `title` of the `<input>`.
   */
  title: PropTypes.string,

  /**
   * The value of the `<input>`.
   */
  value: PropTypes.oneOfType([PropTypes.string, PropTypes.number]).isRequired
};
export var ExpandableTile = /*#__PURE__*/function (_Component3) {
  _inherits(ExpandableTile, _Component3);

  var _super3 = _createSuper(ExpandableTile);

  function ExpandableTile() {
    var _this2;

    _classCallCheck(this, ExpandableTile);

    for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }

    _this2 = _super3.call.apply(_super3, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this2), "state", {});

    _defineProperty(_assertThisInitialized(_this2), "resizeObserver", null);

    _defineProperty(_assertThisInitialized(_this2), "componentDidMount", function () {
      _this2.resizeObserver = new ResizeObserver(function (entries) {
        var _entries = _slicedToArray(entries, 1),
            aboveTheFold = _entries[0];

        _this2.setState({
          tileMaxHeight: aboveTheFold.contentRect.height
        });
      });

      if (_this2.tile) {
        var getStyle = window.getComputedStyle(_this2.tile, null);

        if (_this2.aboveTheFold) {
          _this2.resizeObserver.observe(_this2.aboveTheFold);

          _this2.setState({
            tileMaxHeight: _this2.aboveTheFold.getBoundingClientRect().height,
            tilePadding: parseInt(getStyle.getPropertyValue('padding-top'), 10) + parseInt(getStyle.getPropertyValue('padding-bottom'), 10)
          });
        }
      }
    });

    _defineProperty(_assertThisInitialized(_this2), "componentDidUpdate", function (prevProps) {
      if (prevProps.expanded !== _this2.props.expanded) {
        _this2.setMaxHeight();
      }
    });

    _defineProperty(_assertThisInitialized(_this2), "setMaxHeight", function () {
      if (_this2.state.expanded ? _this2.tileContent : _this2.aboveTheFold) {
        _this2.setState({
          tileMaxHeight: _this2.state.expanded ? _this2.tileContent.getBoundingClientRect().height : _this2.aboveTheFold.getBoundingClientRect().height
        });
      }
    });

    _defineProperty(_assertThisInitialized(_this2), "handleClick", function (evt) {
      if (!_this2.props.onBeforeClick(evt) || evt.target.tagName === 'INPUT') {
        return;
      }

      evt.persist();

      _this2.setState({
        expanded: !_this2.state.expanded
      }, function () {
        var _this2$props$handleCl, _this2$props, _this2$props$onClick, _this2$props2;

        _this2.setMaxHeight(); // TODO: Remove handleClick prop when handleClick is deprecated


        ((_this2$props$handleCl = (_this2$props = _this2.props).handleClick) === null || _this2$props$handleCl === void 0 ? void 0 : _this2$props$handleCl.call(_this2$props, evt)) || ((_this2$props$onClick = (_this2$props2 = _this2.props).onClick) === null || _this2$props$onClick === void 0 ? void 0 : _this2$props$onClick.call(_this2$props2, evt));
      });
    });

    _defineProperty(_assertThisInitialized(_this2), "handleKeyUp", function (evt) {
      if (evt.target !== _this2.tile) {
        if (matches(evt, [keys.Enter, keys.Space])) {
          evt.preventDefault();
        }
      }
    });

    _defineProperty(_assertThisInitialized(_this2), "getChildren", function () {
      return React.Children.toArray(_this2.props.children);
    });

    return _this2;
  }

  _createClass(ExpandableTile, [{
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.resizeObserver) {
        this.resizeObserver.disconnect();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _cx5,
          _this3 = this;

      var _this$props7 = this.props,
          tabIndex = _this$props7.tabIndex,
          className = _this$props7.className,
          expanded = _this$props7.expanded,
          tileMaxHeight = _this$props7.tileMaxHeight,
          tilePadding = _this$props7.tilePadding,
          handleClick = _this$props7.handleClick,
          onClick = _this$props7.onClick,
          onKeyUp = _this$props7.onKeyUp,
          tileCollapsedIconText = _this$props7.tileCollapsedIconText,
          tileExpandedIconText = _this$props7.tileExpandedIconText,
          tileCollapsedLabel = _this$props7.tileCollapsedLabel,
          tileExpandedLabel = _this$props7.tileExpandedLabel,
          onBeforeClick = _this$props7.onBeforeClick,
          light = _this$props7.light,
          rest = _objectWithoutProperties(_this$props7, _excluded4);

      var prefix = this.context;
      var isExpanded = this.state.expanded;
      var classes = cx("".concat(prefix, "--tile"), "".concat(prefix, "--tile--expandable"), (_cx5 = {}, _defineProperty(_cx5, "".concat(prefix, "--tile--is-expanded"), isExpanded), _defineProperty(_cx5, "".concat(prefix, "--tile--light"), light), _cx5), className);
      var tileStyle = {
        maxHeight: isExpanded ? null : this.state.tileMaxHeight + this.state.tilePadding
      };
      var childrenAsArray = this.getChildren();
      return (
        /*#__PURE__*/
        // eslint-disable-next-line jsx-a11y/click-events-have-key-events,jsx-a11y/no-static-element-interactions
        React.createElement("button", _extends({
          type: "button",
          ref: function ref(tile) {
            _this3.tile = tile;
          },
          style: tileStyle,
          className: classes,
          "aria-expanded": isExpanded,
          title: isExpanded ? tileExpandedIconText : tileCollapsedIconText
        }, rest, {
          onKeyUp: composeEventHandlers([onKeyUp, this.handleKeyUp]),
          onClick: composeEventHandlers([onClick, this.handleClick]),
          tabIndex: tabIndex
        }), /*#__PURE__*/React.createElement("div", {
          ref: function ref(tileContent) {
            _this3.tileContent = tileContent;
          }
        }, /*#__PURE__*/React.createElement("div", {
          ref: function ref(aboveTheFold) {
            _this3.aboveTheFold = aboveTheFold;
          },
          className: "".concat(prefix, "--tile-content")
        }, childrenAsArray[0]), /*#__PURE__*/React.createElement("div", {
          className: "".concat(prefix, "--tile__chevron")
        }, /*#__PURE__*/React.createElement("span", null, isExpanded ? tileExpandedLabel : tileCollapsedLabel), /*#__PURE__*/React.createElement(ChevronDown16, null)), /*#__PURE__*/React.createElement("div", {
          className: "".concat(prefix, "--tile-content")
        }, childrenAsArray[1])))
      );
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps( // eslint-disable-next-line react/prop-types
    _ref2, state) {
      var expanded = _ref2.expanded,
          tileMaxHeight = _ref2.tileMaxHeight,
          tilePadding = _ref2.tilePadding;
      var prevExpanded = state.prevExpanded,
          prevTileMaxHeight = state.prevTileMaxHeight,
          prevTilePadding = state.prevTilePadding,
          currentExpanded = state.expanded,
          currentTileMaxHeight = state.tileMaxHeight,
          currentTilePadding = state.tilePadding;
      var expandedChanged = prevExpanded !== expanded;
      var tileMaxHeightChanged = prevTileMaxHeight !== tileMaxHeight;
      var tilePaddingChanged = prevTilePadding !== tilePadding;
      return !expandedChanged && !tileMaxHeightChanged && !tilePaddingChanged ? null : {
        expanded: !expandedChanged ? currentExpanded : expanded,
        tileMaxHeight: !tileMaxHeightChanged ? currentTileMaxHeight : tileMaxHeight,
        tilePadding: !tilePaddingChanged ? currentTilePadding : tilePadding,
        prevExpanded: expanded,
        prevTileMaxHeight: tileMaxHeight,
        prevTilePadding: tilePadding
      };
    }
  }]);

  return ExpandableTile;
}(Component);

_defineProperty(ExpandableTile, "propTypes", {
  /**
   * The child nodes.
   */
  children: PropTypes.node,

  /**
   * The CSS class names.
   */
  className: PropTypes.string,

  /**
   * `true` if the tile is expanded.
   */
  expanded: PropTypes.bool,

  /**
   * Deprecated in v11. Use 'onClick' instead.
   */
  handleClick: deprecate(PropTypes.func, 'The handleClick prop for ClickableTile has been deprecated in favor of onClick. It will be removed in the next major release.'),

  /**
   * An ID that can be provided to aria-labelledby
   */
  id: PropTypes.string,

  /**
   * `true` to use the light version. For use on $ui-01 backgrounds only.
   * Don't use this to make tile background color same as container background color.
   */
  light: PropTypes.bool,

  /**
   * optional handler to decide whether to ignore a click. returns false if click should be ignored
   */
  onBeforeClick: PropTypes.func,

  /**
   * Specify the function to run when the ExpandableTile is clicked
    */
  onClick: PropTypes.func,

  /**
   * optional handler to trigger a function when a key is pressed
   */
  onKeyUp: PropTypes.func,

  /**
   * The `tabindex` attribute.
   */
  tabIndex: PropTypes.number,

  /**
   * The description of the "collapsed" icon that can be read by screen readers.
   */
  tileCollapsedIconText: PropTypes.string,

  /**
   * When "collapsed", a label to appear next to the chevron (e.g., "View more").
   */
  tileCollapsedLabel: PropTypes.string,

  /**
   * The description of the "expanded" icon that can be read by screen readers.
   */
  tileExpandedIconText: PropTypes.string,

  /**
   * When "expanded", a label to appear next to the chevron (e.g., "View less").
   */
  tileExpandedLabel: PropTypes.string
});

_defineProperty(ExpandableTile, "contextType", PrefixContext);

_defineProperty(ExpandableTile, "defaultProps", {
  tabIndex: 0,
  expanded: false,
  tileMaxHeight: 0,
  tilePadding: 0,
  onBeforeClick: function onBeforeClick() {
    return true;
  },
  onClick: function onClick() {},
  tileCollapsedIconText: 'Interact to expand Tile',
  tileExpandedIconText: 'Interact to collapse Tile',
  light: false
});

export var TileAboveTheFoldContent = /*#__PURE__*/function (_Component4) {
  _inherits(TileAboveTheFoldContent, _Component4);

  var _super4 = _createSuper(TileAboveTheFoldContent);

  function TileAboveTheFoldContent() {
    _classCallCheck(this, TileAboveTheFoldContent);

    return _super4.apply(this, arguments);
  }

  _createClass(TileAboveTheFoldContent, [{
    key: "render",
    value: function render() {
      var prefix = this.context;
      var children = this.props.children;
      return /*#__PURE__*/React.createElement("span", {
        className: "".concat(prefix, "--tile-content__above-the-fold")
      }, children);
    }
  }]);

  return TileAboveTheFoldContent;
}(Component);

_defineProperty(TileAboveTheFoldContent, "propTypes", {
  /**
   * The child nodes.
   */
  children: PropTypes.node
});

_defineProperty(TileAboveTheFoldContent, "contextType", PrefixContext);

export var TileBelowTheFoldContent = /*#__PURE__*/function (_Component5) {
  _inherits(TileBelowTheFoldContent, _Component5);

  var _super5 = _createSuper(TileBelowTheFoldContent);

  function TileBelowTheFoldContent() {
    _classCallCheck(this, TileBelowTheFoldContent);

    return _super5.apply(this, arguments);
  }

  _createClass(TileBelowTheFoldContent, [{
    key: "render",
    value: function render() {
      var children = this.props.children;
      var prefix = this.context;
      return /*#__PURE__*/React.createElement("span", {
        className: "".concat(prefix, "--tile-content__below-the-fold")
      }, children);
    }
  }]);

  return TileBelowTheFoldContent;
}(Component);

_defineProperty(TileBelowTheFoldContent, "propTypes", {
  /**
   * The child nodes.
   */
  children: PropTypes.node
});

_defineProperty(TileBelowTheFoldContent, "contextType", PrefixContext);