import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "light"],
    _excluded2 = ["children", "className", "clicked", "handleClick", "handleKeyDown", "href", "light", "onClick", "onKeyDown"],
    _excluded3 = ["children", "className", "disabled", "handleClick", "handleKeyDown", "iconDescription", "id", "light", "name", "onClick", "onChange", "onKeyDown", "selected", "tabIndex", "title", "value"],
    _excluded4 = ["tabIndex", "className", "children", "expanded", "tileMaxHeight", "tilePadding", "onClick", "onKeyUp", "tileCollapsedIconText", "tileExpandedIconText", "tileCollapsedLabel", "tileExpandedLabel", "onBeforeClick", "light"];
import React, { useEffect, useRef, useState } from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import { Checkbox16, CheckboxCheckedFilled16, ChevronDown16 } from '@carbon/icons-react';
import Link from '../../Link';
import { keys, matches } from '../../../internal/keyboard';
import deprecate from '../../../prop-types/deprecate';
import { composeEventHandlers } from '../../../tools/events';
import { usePrefix } from '../../../internal/usePrefix';
import useIsomorphicEffect from '../../../internal/useIsomorphicEffect';
export var Tile = /*#__PURE__*/React.forwardRef(function Tile(_ref, ref) {
  var children = _ref.children,
      className = _ref.className,
      _ref$light = _ref.light,
      light = _ref$light === void 0 ? false : _ref$light,
      rest = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  var tileClasses = cx("".concat(prefix, "--tile"), _defineProperty({}, "".concat(prefix, "--tile--light"), light), className);
  return /*#__PURE__*/React.createElement("div", _extends({
    className: tileClasses,
    ref: ref
  }, rest), children);
});
Tile.displayName = 'Tile';
Tile.propTypes = {
  /**
   * The child nodes.
   */
  children: PropTypes.node,

  /**
   * The CSS class names.
   */
  className: PropTypes.string,

  /**
   * `true` to use the light version. For use on $ui-01 backgrounds only.
   * Don't use this to make tile background color same as container background color.
   */
  light: deprecate(PropTypes.bool, 'The `light` prop for `Tile` is no longer needed and has been deprecated. It will be removed in the next major release. Use the Layer component instead.')
};
export var ClickableTile = /*#__PURE__*/React.forwardRef(function ClickableTile(_ref2, ref) {
  var _cx2;

  var children = _ref2.children,
      className = _ref2.className,
      _ref2$clicked = _ref2.clicked,
      clicked = _ref2$clicked === void 0 ? false : _ref2$clicked,
      handleClick = _ref2.handleClick,
      handleKeyDown = _ref2.handleKeyDown,
      href = _ref2.href,
      _ref2$light = _ref2.light,
      light = _ref2$light === void 0 ? false : _ref2$light,
      _ref2$onClick = _ref2.onClick,
      onClick = _ref2$onClick === void 0 ? function () {} : _ref2$onClick,
      _ref2$onKeyDown = _ref2.onKeyDown,
      onKeyDown = _ref2$onKeyDown === void 0 ? function () {} : _ref2$onKeyDown,
      rest = _objectWithoutProperties(_ref2, _excluded2);

  var prefix = usePrefix();
  var classes = cx("".concat(prefix, "--tile"), "".concat(prefix, "--tile--clickable"), (_cx2 = {}, _defineProperty(_cx2, "".concat(prefix, "--tile--is-clicked"), clicked), _defineProperty(_cx2, "".concat(prefix, "--tile--light"), light), _cx2), className);

  var _useState = useState(clicked),
      _useState2 = _slicedToArray(_useState, 2),
      isSelected = _useState2[0],
      setIsSelected = _useState2[1]; // TODO: replace with onClick when handleClick prop is deprecated


  var clickHandler = handleClick || onClick; // TODO: replace with onClick when handleClick prop is deprecated

  var keyDownHandler = handleKeyDown || onKeyDown;

  function handleOnClick(evt) {
    evt.persist();
    setIsSelected(!isSelected);
    clickHandler(evt);
  }

  function handleOnKeyDown(evt) {
    evt.persist();

    if (matches(evt, [keys.Enter, keys.Space])) {
      evt.preventDefault();
      setIsSelected(!isSelected);
      keyDownHandler(evt);
    }

    keyDownHandler(evt);
  }

  return /*#__PURE__*/React.createElement(Link, _extends({
    className: classes,
    href: href,
    onClick: handleOnClick,
    onKeyDown: handleOnKeyDown,
    ref: ref
  }, rest), children);
});
ClickableTile.displayName = 'ClickableTile';
ClickableTile.propTypes = {
  /**
   * The child nodes.
   */
  children: PropTypes.node,

  /**
   * The CSS class names.
   */
  className: PropTypes.string,

  /**
   * Boolean for whether a tile has been clicked.
   */
  clicked: PropTypes.bool,

  /**
   * Deprecated in v11. Use 'onClick' instead.
   */
  handleClick: deprecate(PropTypes.func, 'The handleClick prop for ClickableTile has been deprecated in favor of onClick. It will be removed in the next major release.'),

  /**
   * Specify the function to run when the ClickableTile is interacted with via a keyboard
   */
  handleKeyDown: deprecate(PropTypes.func, 'The handleKeyDown prop for ClickableTile has been deprecated in favor of onKeyDown. It will be removed in the next major release.'),

  /**
   * The href for the link.
   */
  href: PropTypes.string,

  /**
   * `true` to use the light version. For use on $ui-01 backgrounds only.
   * Don't use this to make tile background color same as container background color.
   */
  light: deprecate(PropTypes.bool, 'The `light` prop for `ClickableTile` is no longer needed and has been deprecated. It will be removed in the next major release. Use the Layer component instead.'),

  /**
   * Specify the function to run when the ClickableTile is clicked
   */
  onClick: PropTypes.func,

  /**
   * Specify the function to run when the ClickableTile is interacted with via a keyboard
   */
  onKeyDown: PropTypes.func,

  /**
   * The rel property for the link.
   */
  rel: PropTypes.string
};
export var SelectableTile = /*#__PURE__*/React.forwardRef(function SelectableTile(_ref3, ref) {
  var _cx3;

  var children = _ref3.children,
      className = _ref3.className,
      disabled = _ref3.disabled,
      handleClick = _ref3.handleClick,
      handleKeyDown = _ref3.handleKeyDown,
      iconDescription = _ref3.iconDescription,
      id = _ref3.id,
      _ref3$light = _ref3.light,
      light = _ref3$light === void 0 ? false : _ref3$light,
      name = _ref3.name,
      _ref3$onClick = _ref3.onClick,
      onClick = _ref3$onClick === void 0 ? function () {} : _ref3$onClick,
      _ref3$onChange = _ref3.onChange,
      onChange = _ref3$onChange === void 0 ? function () {} : _ref3$onChange,
      _ref3$onKeyDown = _ref3.onKeyDown,
      onKeyDown = _ref3$onKeyDown === void 0 ? function () {} : _ref3$onKeyDown,
      _ref3$selected = _ref3.selected,
      selected = _ref3$selected === void 0 ? false : _ref3$selected,
      _ref3$tabIndex = _ref3.tabIndex,
      tabIndex = _ref3$tabIndex === void 0 ? 0 : _ref3$tabIndex,
      _ref3$title = _ref3.title,
      title = _ref3$title === void 0 ? 'title' : _ref3$title,
      _ref3$value = _ref3.value,
      value = _ref3$value === void 0 ? 'value' : _ref3$value,
      rest = _objectWithoutProperties(_ref3, _excluded3);

  var prefix = usePrefix(); // TODO: replace with onClick when handleClick prop is deprecated

  var clickHandler = handleClick || onClick; // TODO: replace with onKeyDown when handleKeyDown prop is deprecated

  var keyDownHandler = handleKeyDown || onKeyDown;

  var _useState3 = useState(selected),
      _useState4 = _slicedToArray(_useState3, 2),
      isSelected = _useState4[0],
      setIsSelected = _useState4[1];

  var _useState5 = useState(selected),
      _useState6 = _slicedToArray(_useState5, 2),
      prevSelected = _useState6[0],
      setPrevSelected = _useState6[1];

  var classes = cx("".concat(prefix, "--tile"), "".concat(prefix, "--tile--selectable"), (_cx3 = {}, _defineProperty(_cx3, "".concat(prefix, "--tile--is-selected"), isSelected), _defineProperty(_cx3, "".concat(prefix, "--tile--light"), light), _defineProperty(_cx3, "".concat(prefix, "--tile--disabled"), disabled), _cx3), className);
  var inputClasses = cx("".concat(prefix, "--tile-input"), _defineProperty({}, "".concat(prefix, "--tile-input--checked"), isSelected)); // TODO: rename to handleClick when handleClick prop is deprecated

  function handleOnClick(evt) {
    evt.preventDefault();
    evt.persist();
    setIsSelected(!isSelected);
    clickHandler(evt);
    onChange(evt);
  } // TODO: rename to handleKeyDown when handleKeyDown prop is deprecated


  function handleOnKeyDown(evt) {
    evt.persist();

    if (matches(evt, [keys.Enter, keys.Space])) {
      evt.preventDefault();
      setIsSelected(!isSelected);
      onChange(evt);
    }

    keyDownHandler(evt);
  }

  function handleChange(event) {
    setIsSelected(event.target.checked);
    onChange(event);
  }

  if (selected !== prevSelected) {
    setIsSelected(selected);
    setPrevSelected(selected);
  }

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("input", {
    checked: isSelected,
    className: inputClasses,
    disabled: disabled,
    id: id,
    name: name,
    onChange: !disabled ? handleChange : null,
    ref: ref,
    tabIndex: -1,
    title: title,
    type: "checkbox",
    value: value
  }), /*#__PURE__*/React.createElement("label", _extends({
    className: classes,
    htmlFor: id,
    onClick: !disabled ? handleOnClick : null,
    onKeyDown: !disabled ? handleOnKeyDown : null // eslint-disable-next-line jsx-a11y/no-noninteractive-tabindex
    ,
    tabIndex: !disabled ? tabIndex : null
  }, rest), /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--tile__checkmark ").concat(prefix, "--tile__checkmark--persistent")
  }, isSelected ? /*#__PURE__*/React.createElement(CheckboxCheckedFilled16, null) : /*#__PURE__*/React.createElement(Checkbox16, null)), /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--tile-content")
  }, children)));
});
SelectableTile.displayName = 'SelectableTile';
SelectableTile.propTypes = {
  /**
   * The child nodes.
   */
  children: PropTypes.node,

  /**
   * The CSS class names.
   */
  className: PropTypes.string,

  /**
   * Specify whether the SelectableTile should be disabled
   */
  disabled: PropTypes.bool,

  /**
   * Specify the function to run when the SelectableTile is clicked
   */
  handleClick: deprecate(PropTypes.func, 'The `handleClick` prop for `SelectableTile` has been deprecated in favor of `onClick`. It will be removed in the next major release.'),

  /**
   * Specify the function to run when the SelectableTile is interacted with via a keyboard
   */
  handleKeyDown: deprecate(PropTypes.func, 'The `handleKeyDown` prop for `SelectableTile` has been deprecated in favor of `onKeyDown`. It will be removed in the next major release.'),

  /**
   * The description of the checkmark icon.
   */
  iconDescription: deprecate(PropTypes.string, 'The `iconDescription` prop for `SelectableTile` is no longer needed and has ' + 'been deprecated. It will be removed in the next major release.'),

  /**
   * The ID of the `<input>`.
   */
  id: PropTypes.string,

  /**
   * `true` to use the light version. For use on $ui-01 backgrounds only.
   * Don't use this to make tile background color same as container background color.
   */
  light: deprecate(PropTypes.bool, 'The `light` prop for `SelectableTile` is no longer needed and has been deprecated. It will be removed in the next major release. Use the Layer component instead.'),

  /**
   * The `name` of the `<input>`.
   */
  name: PropTypes.string,

  /**
   * The empty handler of the `<input>`.
   */
  onChange: PropTypes.func,

  /**
   * Specify the function to run when the SelectableTile is clicked
   */
  onClick: PropTypes.func,

  /**
   * Specify the function to run when the SelectableTile is interacted with via a keyboard
   */
  onKeyDown: PropTypes.func,

  /**
   * `true` to select this tile.
   */
  selected: PropTypes.bool,

  /**
   * Specify the tab index of the wrapper element
   */
  tabIndex: PropTypes.number,

  /**
   * The `title` of the `<input>`.
   */
  title: PropTypes.string,

  /**
   * The value of the `<input>`.
   */
  value: PropTypes.oneOfType([PropTypes.string, PropTypes.number]).isRequired
};
export function ExpandableTile(_ref4) {
  var _cx5;

  var tabIndex = _ref4.tabIndex,
      className = _ref4.className,
      children = _ref4.children,
      expanded = _ref4.expanded,
      tileMaxHeight = _ref4.tileMaxHeight,
      tilePadding = _ref4.tilePadding,
      onClick = _ref4.onClick,
      onKeyUp = _ref4.onKeyUp,
      tileCollapsedIconText = _ref4.tileCollapsedIconText,
      tileExpandedIconText = _ref4.tileExpandedIconText,
      tileCollapsedLabel = _ref4.tileCollapsedLabel,
      tileExpandedLabel = _ref4.tileExpandedLabel,
      onBeforeClick = _ref4.onBeforeClick,
      light = _ref4.light,
      rest = _objectWithoutProperties(_ref4, _excluded4);

  var _useState7 = useState(tileMaxHeight),
      _useState8 = _slicedToArray(_useState7, 2),
      isTileMaxHeight = _useState8[0],
      setIsTileMaxHeight = _useState8[1];

  var _useState9 = useState(tilePadding),
      _useState10 = _slicedToArray(_useState9, 2),
      isTilePadding = _useState10[0],
      setIsTilePadding = _useState10[1];

  var _useState11 = useState(expanded),
      _useState12 = _slicedToArray(_useState11, 2),
      prevExpanded = _useState12[0],
      setPrevExpanded = _useState12[1];

  var _useState13 = useState(tileMaxHeight),
      _useState14 = _slicedToArray(_useState13, 2),
      prevTileMaxHeight = _useState14[0],
      setPrevTileMaxHeight = _useState14[1];

  var _useState15 = useState(tilePadding),
      _useState16 = _slicedToArray(_useState15, 2),
      prevTilePadding = _useState16[0],
      setPrevTilePadding = _useState16[1];

  var _useState17 = useState(expanded),
      _useState18 = _slicedToArray(_useState17, 2),
      isExpanded = _useState18[0],
      setIsExpanded = _useState18[1];

  var aboveTheFold = useRef(null);
  var tileContent = useRef(null);
  var tile = useRef(null);
  var prefix = usePrefix();

  if (expanded !== prevExpanded) {
    setIsExpanded(expanded);
    setPrevExpanded(expanded);
    setMaxHeight();
  }

  if (tileMaxHeight !== prevTileMaxHeight) {
    setIsTileMaxHeight(tileMaxHeight);
    setPrevTileMaxHeight(tileMaxHeight);
  }

  if (tilePadding !== prevTilePadding) {
    setIsTilePadding(tilePadding);
    setPrevTilePadding(tilePadding);
  }

  function setMaxHeight() {
    if (isExpanded) {
      setIsTileMaxHeight(tileContent.current.getBoundingClientRect().height);
    }

    setIsTileMaxHeight(aboveTheFold.current.getBoundingClientRect().height);
  }

  function handleClick(evt) {
    if (!onBeforeClick(evt) || evt.target.tagName === 'INPUT') {
      return;
    }

    evt.persist();
    setIsExpanded(!isExpanded);
    setMaxHeight();

    if (onClick) {
      onClick(evt);
    }
  }

  function handleKeyUp(evt) {
    if (evt.target !== tile.current) {
      if (matches(evt, [keys.Enter, keys.Space])) {
        evt.preventDefault();
      }
    }
  }

  function getChildren() {
    return React.Children.toArray(children);
  }

  var classes = cx("".concat(prefix, "--tile"), "".concat(prefix, "--tile--expandable"), (_cx5 = {}, _defineProperty(_cx5, "".concat(prefix, "--tile--is-expanded"), isExpanded), _defineProperty(_cx5, "".concat(prefix, "--tile--light"), light), _cx5), className);
  var tileStyle = {
    maxHeight: isExpanded ? null : isTileMaxHeight + isTilePadding
  };
  var childrenAsArray = getChildren();
  useIsomorphicEffect(function () {
    var getStyle = window.getComputedStyle(tile.current, null);
    var node = aboveTheFold.current;

    var _node$getBoundingClie = node.getBoundingClientRect(),
        height = _node$getBoundingClie.height;

    var paddingTop = parseInt(getStyle.getPropertyValue('padding-top'), 10);
    var paddingBottom = parseInt(getStyle.getPropertyValue('padding-bottom'), 10);
    setIsTileMaxHeight(height);
    setIsTilePadding(paddingTop + paddingBottom);
  }, []);
  useEffect(function () {
    var resizeObserver = new ResizeObserver(function (entries) {
      var _entries = _slicedToArray(entries, 1),
          aboveTheFold = _entries[0];

      setIsTileMaxHeight(aboveTheFold.contentRect.height);
    });
    resizeObserver.observe(aboveTheFold.current);
    return function () {
      return resizeObserver.disconnect();
    };
  }, []);
  return /*#__PURE__*/React.createElement("button", _extends({
    type: "button",
    ref: tile,
    style: tileStyle,
    className: classes,
    "aria-expanded": isExpanded,
    title: isExpanded ? tileExpandedIconText : tileCollapsedIconText
  }, rest, {
    onKeyUp: composeEventHandlers([onKeyUp, handleKeyUp]),
    onClick: composeEventHandlers([onClick, handleClick]),
    tabIndex: tabIndex
  }), /*#__PURE__*/React.createElement("div", {
    ref: tileContent
  }, /*#__PURE__*/React.createElement("div", {
    ref: aboveTheFold,
    className: "".concat(prefix, "--tile-content")
  }, childrenAsArray[0]), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--tile__chevron")
  }, /*#__PURE__*/React.createElement("span", null, isExpanded ? tileExpandedLabel : tileCollapsedLabel), /*#__PURE__*/React.createElement(ChevronDown16, null)), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--tile-content")
  }, childrenAsArray[1])));
}
ExpandableTile.propTypes = {
  /**
   * The child nodes.
   */
  children: PropTypes.node,

  /**
   * The CSS class names.
   */
  className: PropTypes.string,

  /**
   * `true` if the tile is expanded.
   */
  expanded: PropTypes.bool,

  /**
   * An ID that can be provided to aria-labelledby
   */
  id: PropTypes.string,

  /**
   * `true` to use the light version. For use on $ui-01 backgrounds only.
   * Don't use this to make tile background color same as container background color.
   */
  light: deprecate(PropTypes.bool, 'The `light` prop for `ExpandableTile` is no longer needed and has been deprecated. It will be removed in the next major release. Use the Layer component instead.'),

  /**
   * optional handler to decide whether to ignore a click. returns false if click should be ignored
   */
  onBeforeClick: PropTypes.func,

  /**
   * Specify the function to run when the ExpandableTile is clicked
   */
  onClick: PropTypes.func,

  /**
   * optional handler to trigger a function when a key is pressed
   */
  onKeyUp: PropTypes.func,

  /**
   * The `tabindex` attribute.
   */
  tabIndex: PropTypes.number,

  /**
   * The description of the "collapsed" icon that can be read by screen readers.
   */
  tileCollapsedIconText: PropTypes.string,

  /**
   * When "collapsed", a label to appear next to the chevron (e.g., "View more").
   */
  tileCollapsedLabel: PropTypes.string,

  /**
   * The description of the "expanded" icon that can be read by screen readers.
   */
  tileExpandedIconText: PropTypes.string,

  /**
   * When "expanded", a label to appear next to the chevron (e.g., "View less").
   */
  tileExpandedLabel: PropTypes.string
};
ExpandableTile.defaultProps = {
  tabIndex: 0,
  expanded: false,
  tileMaxHeight: 0,
  tilePadding: 0,
  onBeforeClick: function onBeforeClick() {
    return true;
  },
  onClick: function onClick() {},
  tileCollapsedIconText: 'Interact to expand Tile',
  tileExpandedIconText: 'Interact to collapse Tile'
};
ExpandableTile.displayName = 'ExpandableTile';
export var TileAboveTheFoldContent = /*#__PURE__*/React.forwardRef(function TilAboveTheFoldContent(_ref5, ref) {
  var children = _ref5.children;
  var prefix = usePrefix();
  return /*#__PURE__*/React.createElement("span", {
    ref: ref,
    className: "".concat(prefix, "--tile-content__above-the-fold")
  }, children);
});
TileAboveTheFoldContent.propTypes = {
  /**
   * The child nodes.
   */
  children: PropTypes.node
};
TileAboveTheFoldContent.displayName = 'TileAboveTheFoldContent';
export var TileBelowTheFoldContent = /*#__PURE__*/React.forwardRef(function TileBelowTheFoldContent(_ref6, ref) {
  var children = _ref6.children;
  var prefix = usePrefix();
  return /*#__PURE__*/React.createElement("span", {
    ref: ref,
    className: "".concat(prefix, "--tile-content__below-the-fold")
  }, children);
});
TileBelowTheFoldContent.propTypes = {
  /**
   * The child nodes.
   */
  children: PropTypes.node
};
TileBelowTheFoldContent.displayName = 'TileBelowTheFoldContent';