/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import Link from '../../Link';
import TextInput from '../../TextInput';
import RadioTile from '../../RadioTile';
import { ClickableTile, ExpandableTile, SelectableTile, Tile, TileAboveTheFoldContent, TileBelowTheFoldContent } from '../';
import TileGroup from '../../TileGroup';
import { Layer } from '../../Layer';
import './tile-story.scss';
export default {
  title: 'Components/Tile',
  parameters: {
    component: Tile,
    subcomponents: {
      ClickableTile: ClickableTile,
      SelectableTile: SelectableTile,
      ExpandableTile: ExpandableTile,
      RadioTile: RadioTile,
      TileGroup: TileGroup,
      TileAboveTheFoldContent: TileAboveTheFoldContent,
      TileBelowTheFoldContent: TileBelowTheFoldContent
    }
  }
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(Tile, null, "Default tile", /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement(Link, {
    href: "https://www.carbondesignsystem.com"
  }, "Link"));
};
export var DefaultWithLayer = function DefaultWithLayer() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Tile, null, "First layer", /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement(Link, {
    href: "https://www.carbondesignsystem.com"
  }, "Link")), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(Tile, null, "Second layer", /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement(Link, {
    href: "https://www.carbondesignsystem.com"
  }, "Link")), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(Tile, null, "Third layer", /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement(Link, {
    href: "https://www.carbondesignsystem.com"
  }, "Link")))));
};
export var Clickable = function Clickable() {
  return /*#__PURE__*/React.createElement(ClickableTile, null, "Clickable Tile");
};
export var ClickableWithLayer = function ClickableWithLayer() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(ClickableTile, null, "First layer"), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(ClickableTile, null, "Second layer"), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(ClickableTile, null, "Third layer"))));
};
export var MultiSelect = function MultiSelect() {
  return /*#__PURE__*/React.createElement("div", {
    role: "group",
    "aria-label": "selectable tiles"
  }, /*#__PURE__*/React.createElement(SelectableTile, {
    id: "tile-1",
    name: "tiles"
  }, "Option 1"), /*#__PURE__*/React.createElement(SelectableTile, {
    id: "tile-2",
    name: "tiles"
  }, "Option 2"), /*#__PURE__*/React.createElement(SelectableTile, {
    id: "tile-3",
    name: "tiles"
  }, "Option 3"));
};
export var SelectableWithLayer = function SelectableWithLayer() {
  /*#__PURE__*/
  React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(SelectableTile, {
    id: "tile-3",
    name: "tiles"
  }, "First layer"), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(SelectableTile, {
    id: "tile-3",
    name: "tiles"
  }, "Second layer"), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(SelectableTile, {
    id: "tile-3",
    name: "tiles"
  }, "Third layer"))));
};
export var Radio = function Radio() {
  return /*#__PURE__*/React.createElement(TileGroup, {
    defaultSelected: "default-selected",
    legend: "Radio Tile Group",
    name: "radio tile group"
  }, /*#__PURE__*/React.createElement(RadioTile, {
    value: "standard",
    style: {
      marginBottom: '.5rem'
    }
  }, "Option 1"), /*#__PURE__*/React.createElement(RadioTile, {
    value: "default-selected",
    id: "tile-2"
  }, "Option 2"), /*#__PURE__*/React.createElement(RadioTile, {
    value: "selected",
    id: "tile-3"
  }, "Option 3"));
};
export var RadioWithLayer = function RadioWithLayer() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(TileGroup, {
    defaultSelected: "default-selected",
    legend: "First layer",
    name: "radio tile group"
  }, /*#__PURE__*/React.createElement(RadioTile, {
    value: "standard",
    style: {
      marginBottom: '.5rem'
    }
  }, "Option 1"), /*#__PURE__*/React.createElement(RadioTile, {
    value: "default-selected",
    id: "tile-2"
  }, "Option 2")), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(TileGroup, {
    defaultSelected: "default-selected",
    legend: "Second Layer",
    name: "radio tile group"
  }, /*#__PURE__*/React.createElement(RadioTile, {
    value: "standard",
    style: {
      marginBottom: '.5rem'
    }
  }, "Option 1"), /*#__PURE__*/React.createElement(RadioTile, {
    value: "default-selected",
    id: "tile-2"
  }, "Option 2")), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(TileGroup, {
    defaultSelected: "default-selected",
    legend: "Third Layer",
    name: "radio tile group"
  }, /*#__PURE__*/React.createElement(RadioTile, {
    value: "standard",
    style: {
      marginBottom: '.5rem'
    }
  }, "Option 1"), /*#__PURE__*/React.createElement(RadioTile, {
    value: "default-selected",
    id: "tile-2"
  }, "Option 2")))));
};
export var Expandable = function Expandable() {
  return /*#__PURE__*/React.createElement(ExpandableTile, {
    tileCollapsedIconText: "Interact to Expand tile",
    tileExpandedIconText: "Interact to Collapse tile"
  }, /*#__PURE__*/React.createElement(TileAboveTheFoldContent, null, /*#__PURE__*/React.createElement("div", {
    style: {
      height: '200px'
    }
  }, "Above the fold content here")), /*#__PURE__*/React.createElement(TileBelowTheFoldContent, null, /*#__PURE__*/React.createElement("div", {
    style: {
      height: '400px'
    }
  }, "Below the fold content here", /*#__PURE__*/React.createElement(TextInput, {
    id: "test2",
    invalidText: "A valid value is required"
  }))));
};
export var ExpandableWithLayer = function ExpandableWithLayer() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(ExpandableTile, {
    tileCollapsedIconText: "Interact to Expand tile",
    tileExpandedIconText: "Interact to Collapse tile"
  }, /*#__PURE__*/React.createElement(TileAboveTheFoldContent, null, /*#__PURE__*/React.createElement("div", {
    style: {
      height: '200px'
    }
  }, "First layer")), /*#__PURE__*/React.createElement(TileBelowTheFoldContent, null, /*#__PURE__*/React.createElement("div", {
    style: {
      height: '400px'
    }
  }, "Below the fold content here", /*#__PURE__*/React.createElement(TextInput, {
    id: "test2",
    invalidText: "A valid value is required"
  })))), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(ExpandableTile, {
    tileCollapsedIconText: "Interact to Expand tile",
    tileExpandedIconText: "Interact to Collapse tile"
  }, /*#__PURE__*/React.createElement(TileAboveTheFoldContent, null, /*#__PURE__*/React.createElement("div", {
    style: {
      height: '200px'
    }
  }, "Second layer")), /*#__PURE__*/React.createElement(TileBelowTheFoldContent, null, /*#__PURE__*/React.createElement("div", {
    style: {
      height: '400px'
    }
  }, "Below the fold content here", /*#__PURE__*/React.createElement(TextInput, {
    id: "test2",
    invalidText: "A valid value is required"
  })))), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(ExpandableTile, {
    tileCollapsedIconText: "Interact to Expand tile",
    tileExpandedIconText: "Interact to Collapse tile"
  }, /*#__PURE__*/React.createElement(TileAboveTheFoldContent, null, /*#__PURE__*/React.createElement("div", {
    style: {
      height: '200px'
    }
  }, "Third layer")), /*#__PURE__*/React.createElement(TileBelowTheFoldContent, null, /*#__PURE__*/React.createElement("div", {
    style: {
      height: '400px'
    }
  }, "Below the fold content here", /*#__PURE__*/React.createElement(TextInput, {
    id: "test2",
    invalidText: "A valid value is required"
  })))))));
};