import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["aria-label", "children", "id", "disabled", "className"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import cx from 'classnames';
import { ChevronDown16 } from '@carbon/icons-react';
import { usePrefix } from '../../../internal/usePrefix';
import deprecate from '../../../prop-types/deprecate';
var TimePickerSelect = /*#__PURE__*/React.forwardRef(function TimePickerSelect(_ref, ref) {
  var _cx;

  var _ref$ariaLabel = _ref['aria-label'],
      ariaLabel = _ref$ariaLabel === void 0 ? 'open list of options' : _ref$ariaLabel,
      children = _ref.children,
      id = _ref.id,
      _ref$disabled = _ref.disabled,
      disabled = _ref$disabled === void 0 ? false : _ref$disabled,
      className = _ref.className,
      rest = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  var selectClasses = cx((_cx = {}, _defineProperty(_cx, "".concat(prefix, "--select"), true), _defineProperty(_cx, "".concat(prefix, "--time-picker__select"), true), _defineProperty(_cx, className, className), _cx));
  return /*#__PURE__*/React.createElement("div", {
    className: selectClasses
  }, /*#__PURE__*/React.createElement("select", _extends({
    "aria-label": ariaLabel,
    className: "".concat(prefix, "--select-input"),
    disabled: disabled,
    id: id,
    ref: ref
  }, rest), children), /*#__PURE__*/React.createElement(ChevronDown16, {
    className: "".concat(prefix, "--select__arrow"),
    "aria-hidden": "true"
  }));
});
TimePickerSelect.propTypes = {
  /**
   * Provide the contents of your TimePickerSelect
   */
  children: PropTypes.node,

  /**
   * Specify an optional className to be applied to the node containing the label and the select box
   */
  className: PropTypes.string,

  /**
   * Optionally provide the default value of the `<select>`
   */
  defaultValue: PropTypes.any,

  /**
   * Specify whether the control is disabled
   */
  disabled: PropTypes.bool,

  /**
   * Provide a description for the twistie icon that can be read by screen readers
   */
  iconDescription: deprecate(PropTypes.string, 'The `iconDescription` prop for `TimePickerSelect` is no longer needed and has ' + 'been deprecated. It will be moved in the next major release. Use "aria-label" instead'),

  /**
   * Specify a custom `id` for the `<select>`
   */
  id: PropTypes.string.isRequired
};
export default TimePickerSelect;