/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { Toggle, ToggleSkeleton } from 'carbon-components-react';
export default {
  title: 'Components/Toggle',
  parameters: {
    component: Toggle
  }
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(Toggle, {
    labelText: "Toggle element label",
    labelA: "Off",
    labelB: "On",
    defaultToggled: true,
    id: "toggle-1"
  });
};
export var SmallToggle = function SmallToggle() {
  return /*#__PURE__*/React.createElement(Toggle, {
    size: "sm",
    labelText: "Toggle element label",
    labelA: "Off",
    labelB: "On",
    defaultToggled: true,
    id: "toggle-2"
  });
};
export var Skeleton = function Skeleton() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("p", null, "Medium toggle skeleton with label"), /*#__PURE__*/React.createElement(ToggleSkeleton, {
    labelText: "Toggle label",
    id: "toggle-skeleton-id"
  }), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement("p", null, "Small toggle skeleton with label"), /*#__PURE__*/React.createElement(ToggleSkeleton, {
    labelText: "Toggle label",
    id: "toggle-skeleton-id",
    size: "sm"
  }));
};