import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useState } from 'react';
import { settings } from 'carbon-components';
import { withKnobs, select, text, number, boolean } from '@storybook/addon-knobs';
import Tooltip from '../Tooltip';
import { Tooltip as OGTooltip } from './Tooltip';
import Button from '../Button';
import { OverflowMenuVertical16 } from '@carbon/icons-react';
import mdx from './Tooltip.mdx';
var prefix = settings.prefix;
var directions = {
  'Bottom (bottom)': 'bottom',
  'Left (left)': 'left',
  'Top (top)': 'top',
  'Right (right)': 'right'
};
var alignments = {
  'Start (start)': 'start',
  'Center (center)': 'center',
  'End (end)': 'end'
};
var props = {
  withIcon: function withIcon() {
    return {
      align: select('Tooltip alignment (align)', alignments, 'center'),
      direction: select('Tooltip direction (direction)', directions, 'bottom'),
      triggerText: text('Trigger text (triggerText)', 'Tooltip label'),
      tabIndex: number('Tab index (tabIndex in <Tooltip>)', 0),
      selectorPrimaryFocus: text('Primary focus element selector (selectorPrimaryFocus)', '')
    };
  },
  autoOrientation: function autoOrientation() {
    return {
      align: select('Tooltip alignment (align)', alignments, 'center'),
      direction: select('Tooltip direction (direction)', directions, 'bottom'),
      triggerText: text('Trigger text (triggerText)', 'Test'),
      tabIndex: number('Tab index (tabIndex in <Tooltip>)', 0),
      selectorPrimaryFocus: text('Primary focus element selector (selectorPrimaryFocus)', ''),
      autoOrientation: boolean('Auto orientation', true)
    };
  },
  withoutIcon: function withoutIcon() {
    return {
      showIcon: false,
      align: select('Tooltip alignment (align)', alignments, 'center'),
      direction: select('Tooltip direction (direction)', directions, 'bottom'),
      triggerText: text('Trigger text (triggerText)', 'Tooltip label'),
      tabIndex: number('Tab index (tabIndex in <Tooltip>)', 0),
      selectorPrimaryFocus: text('Primary focus element selector (selectorPrimaryFocus)', '')
    };
  },
  customIcon: function customIcon() {
    return {
      showIcon: true,
      align: select('Tooltip alignment (align)', alignments, 'center'),
      direction: select('Tooltip direction (direction)', directions, 'bottom'),
      triggerText: text('Trigger text (triggerText)', 'Tooltip label'),
      tabIndex: number('Tab index (tabIndex in <Tooltip>)', 0),
      selectorPrimaryFocus: text('Primary focus element selector (selectorPrimaryFocus)', ''),
      // eslint-disable-next-line react/display-name
      renderIcon: function renderIcon() {
        return /*#__PURE__*/React.createElement("svg", {
          xmlns: "http://www.w3.org/2000/svg",
          width: "16",
          height: "16"
        }, /*#__PURE__*/React.createElement("path", {
          d: "M8.5 11V6.5h-2v1h1V11H6v1h4v-1zM8 3.5c-.4 0-.8.3-.8.8s.4.7.8.7.8-.3.8-.8-.4-.7-.8-.7z"
        }), /*#__PURE__*/React.createElement("path", {
          d: "M8 15c-3.9 0-7-3.1-7-7s3.1-7 7-7 7 3.1 7 7-3.1 7-7 7zM8 2C4.7 2 2 4.7 2 8s2.7 6 6 6 6-2.7 6-6-2.7-6-6-6z"
        }), /*#__PURE__*/React.createElement("path", {
          fill: "none",
          d: "M0 0h16v16H0z"
        }));
      }
    };
  },
  customIconOnly: function customIconOnly() {
    return {
      showIcon: true,
      align: select('Tooltip alignment (align)', alignments, 'center'),
      direction: select('Tooltip direction (direction)', directions, 'bottom'),
      iconDescription: 'Helpful Information',
      tabIndex: number('Tab index (tabIndex in <Tooltip>)', 0),
      selectorPrimaryFocus: text('Primary focus element selector (selectorPrimaryFocus)', ''),
      renderIcon: OverflowMenuVertical16
    };
  }
};
var containerStyles = {
  height: 'calc(100vh - 6rem)',
  display: 'flex',
  justifyContent: 'center',
  alignItems: 'center'
};
Tooltip.displayName = 'Tooltip';

function UncontrolledTooltipExample() {
  var _useState = useState(true),
      _useState2 = _slicedToArray(_useState, 2),
      value = _useState2[0],
      setValue = _useState2[1];

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Button, {
    style: {
      padding: '15px 20px',
      margin: '4px 20px'
    },
    onClick: function onClick() {
      return setValue(false);
    }
  }, "Hide"), /*#__PURE__*/React.createElement(Button, {
    style: {
      padding: '15px 20px',
      margin: '4px 20px'
    },
    onClick: function onClick() {
      return setValue(true);
    }
  }, "Show"), /*#__PURE__*/React.createElement("div", {
    style: {
      padding: '15px',
      margin: '4px 20px'
    }
  }, /*#__PURE__*/React.createElement(Tooltip, _extends({}, _objectSpread(_objectSpread({}, props.withoutIcon()), {}, {
    focusTrap: boolean('Focus trap (focusTrap)', true)
  }), {
    triggerText: /*#__PURE__*/React.createElement("div", null, "My text wrapped with tooltip"),
    open: value
  }), /*#__PURE__*/React.createElement("p", {
    id: "tooltip-body"
  }, "This is some tooltip text. This box shows the maximum amount of text that should appear inside. If more room is needed please use a modal instead."), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--tooltip__footer")
  }, /*#__PURE__*/React.createElement("a", {
    href: "/",
    className: "".concat(prefix, "--link")
  }, "Learn More"), /*#__PURE__*/React.createElement(Button, {
    size: "small"
  }, "Create")))));
}

export default {
  title: 'Components/Tooltip',
  component: OGTooltip,
  decorators: [withKnobs],
  parameters: {
    docs: {
      page: mdx
    }
  }
};
export var DefaultBottom = function DefaultBottom() {
  return /*#__PURE__*/React.createElement("div", {
    style: containerStyles
  }, /*#__PURE__*/React.createElement(Tooltip, props.withIcon(), /*#__PURE__*/React.createElement("p", null, "This is some tooltip text. This box shows the maximum amount of text that should appear inside. If more room is needed please use a modal instead.")));
};
DefaultBottom.storyName = 'default (bottom)';
DefaultBottom.parameters = {
  info: {
    text: "\n        Interactive tooltip should be used if there are actions a user can take in the tooltip (e.g. a link or a button).\n        For more regular use case, e.g. giving the user more text information about something, use definition tooltip or icon tooltip.\n        By default, the tooltip will render above the element. The example below shows the default scenario.\n      "
  }
};
export var AutoOrientation = function AutoOrientation() {
  return /*#__PURE__*/React.createElement("div", {
    style: _objectSpread(_objectSpread({}, containerStyles), {}, {
      justifyContent: 'unset',
      alignItems: 'unset',
      flexWrap: 'wrap'
    })
  }, /*#__PURE__*/React.createElement("div", {
    style: {
      flex: '50%'
    }
  }, /*#__PURE__*/React.createElement(Tooltip, _extends({}, props.autoOrientation(), {
    tooltipBodyId: "tooltip-body"
  }), /*#__PURE__*/React.createElement("p", {
    id: "tooltip-body"
  }, "This is some tooltip text. This box shows the maximum amount of text that should appear inside. If more room is needed please use a modal instead."), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--tooltip__footer")
  }, /*#__PURE__*/React.createElement("a", {
    href: "/",
    className: "".concat(prefix, "--link")
  }, "Learn More"), /*#__PURE__*/React.createElement(Button, {
    size: "small"
  }, "Create")))), /*#__PURE__*/React.createElement("div", {
    style: {
      flex: '50%',
      textAlign: 'right'
    }
  }, /*#__PURE__*/React.createElement(Tooltip, _extends({}, props.autoOrientation(), {
    tooltipBodyId: "tooltip-body"
  }), /*#__PURE__*/React.createElement("p", {
    id: "tooltip-body"
  }, "This is some tooltip text. This box shows the maximum amount of text that should appear inside. If more room is needed please use a modal instead."), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--tooltip__footer")
  }, /*#__PURE__*/React.createElement("a", {
    href: "/",
    className: "".concat(prefix, "--link")
  }, "Learn More"), /*#__PURE__*/React.createElement(Button, {
    size: "small"
  }, "Create")))), /*#__PURE__*/React.createElement("div", {
    style: {
      flex: '50%',
      marginTop: 'auto'
    }
  }, /*#__PURE__*/React.createElement(Tooltip, _extends({}, props.autoOrientation(), {
    tooltipBodyId: "tooltip-body"
  }), /*#__PURE__*/React.createElement("p", {
    id: "tooltip-body"
  }, "This is some tooltip text. This box shows the maximum amount of text that should appear inside. If more room is needed please use a modal instead."), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--tooltip__footer")
  }, /*#__PURE__*/React.createElement("a", {
    href: "/",
    className: "".concat(prefix, "--link")
  }, "Learn More"), /*#__PURE__*/React.createElement(Button, {
    size: "small"
  }, "Create")))), /*#__PURE__*/React.createElement("div", {
    style: {
      flex: '50%',
      textAlign: 'right',
      marginTop: 'auto'
    }
  }, /*#__PURE__*/React.createElement(Tooltip, _extends({}, props.autoOrientation(), {
    tooltipBodyId: "tooltip-body"
  }), /*#__PURE__*/React.createElement("p", {
    id: "tooltip-body"
  }, "This is some tooltip text. This box shows the maximum amount of text that should appear inside. If more room is needed please use a modal instead."), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--tooltip__footer")
  }, /*#__PURE__*/React.createElement("a", {
    href: "/",
    className: "".concat(prefix, "--link")
  }, "Learn More"), /*#__PURE__*/React.createElement(Button, {
    size: "small"
  }, "Create")))));
};
AutoOrientation.storyName = 'auto orientation';
AutoOrientation.parameters = {
  info: {
    text: "\n        Interactive tooltip should be used if there are actions a user can take in the tooltip (e.g. a link or a button).\n        For more regular use case, e.g. giving the user more text information about something, use definition tooltip or icon tooltip.\n        By default, the tooltip will render above the element. The example below shows the default scenario.\n      "
  }
};
export var NoIcon = function NoIcon() {
  return /*#__PURE__*/React.createElement("div", {
    style: containerStyles
  }, /*#__PURE__*/React.createElement(Tooltip, props.withoutIcon(), /*#__PURE__*/React.createElement("p", null, "This is some tooltip text. This box shows the maximum amount of text that should appear inside. If more room is needed please use a modal instead."), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--tooltip__footer")
  }, /*#__PURE__*/React.createElement("a", {
    href: "/",
    className: "".concat(prefix, "--link")
  }, "Learn More"), /*#__PURE__*/React.createElement(Button, {
    size: "small"
  }, "Create"))));
};
NoIcon.storyName = 'no icon';
NoIcon.parameters = {
  info: {
    text: "\n        Interactive tooltip should be used if there are actions a user can take in the tooltip (e.g. a link or a button).\n        For more regular use case, e.g. giving the user more text information about something, use definition tooltip or icon tooltip.\n        By default, the tooltip will render with an information Icon. The example below shows the option to exclude the Icon.\n      "
  }
};
export var RenderCustomIcon = function RenderCustomIcon() {
  return /*#__PURE__*/React.createElement("div", {
    style: containerStyles
  }, /*#__PURE__*/React.createElement(Tooltip, props.customIcon(), /*#__PURE__*/React.createElement("p", null, "This is some tooltip text. This box shows the maximum amount of text that should appear inside. If more room is needed please use a modal instead."), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--tooltip__footer")
  }, /*#__PURE__*/React.createElement("a", {
    href: "/",
    className: "".concat(prefix, "--link")
  }, "Learn More"), /*#__PURE__*/React.createElement(Button, {
    size: "small"
  }, "Create"))));
};
RenderCustomIcon.storyName = 'render custom icon';
RenderCustomIcon.parameters = {
  info: {
    text: "\n        Interactive tooltip should be used if there are actions a user can take in the tooltip (e.g. a link or a button).\n        For more regular use case, e.g. giving the user more text information about something, use definition tooltip or icon tooltip.\n        By default, the tooltip will render with an information Icon. The example below shows the option to exclude the Icon.\n      "
  }
};
export var OnlyCustomIcon = function OnlyCustomIcon() {
  return /*#__PURE__*/React.createElement("div", {
    style: containerStyles
  }, /*#__PURE__*/React.createElement(Tooltip, props.customIconOnly(), /*#__PURE__*/React.createElement("p", null, "This is some tooltip text. This box shows the maximum amount of text that should appear inside. If more room is needed please use a modal instead."), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--tooltip__footer")
  }, /*#__PURE__*/React.createElement("a", {
    href: "/",
    className: "".concat(prefix, "--link")
  }, "Learn More"), /*#__PURE__*/React.createElement(Button, {
    size: "small"
  }, "Create"))));
};
OnlyCustomIcon.storyName = 'only custom icon';
OnlyCustomIcon.parameters = {
  info: {
    text: "\n        Interactive tooltip should be used if there are actions a user can take in the tooltip (e.g. a link or a button).\n        For more regular use case, e.g. giving the user more text information about something, use definition tooltip or icon tooltip.\n        By default, the tooltip will render with an information Icon. The example below shows the option to exclude the Icon.\n      "
  }
};
export var UncontrolledTooltip = function UncontrolledTooltip() {
  return /*#__PURE__*/React.createElement(UncontrolledTooltipExample, null);
};
UncontrolledTooltip.storyName = 'uncontrolled tooltip';