import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { Component } from 'react';
import debounce from 'lodash.debounce'; // eslint-disable-line no-unused-vars

import FloatingMenu from '../../internal/FloatingMenu';
import Tooltip from '../Tooltip';
import { mount } from 'enzyme';
import { screen, render } from '@testing-library/react';
import userEvent from '@testing-library/user-event';
import { Information16 as Information, Add16 as Add, OverflowMenuVertical16 } from '@carbon/icons-react';
import { settings } from 'carbon-components';
import '@testing-library/jest-dom';
var prefix = settings.prefix;
jest.mock('lodash.debounce', function () {
  return function (fn) {
    fn.cancel = jest.fn();
    return fn;
  };
});
describe('Tooltip', function () {
  // An icon component class
  var CustomIcon = /*#__PURE__*/function (_Component) {
    _inherits(CustomIcon, _Component);

    var _super = _createSuper(CustomIcon);

    function CustomIcon() {
      _classCallCheck(this, CustomIcon);

      return _super.apply(this, arguments);
    }

    _createClass(CustomIcon, [{
      key: "render",
      value: function render() {
        return /*#__PURE__*/React.createElement("div", null);
      }
    }]);

    return CustomIcon;
  }(Component);

  describe('Renders as expected with defaults', function () {
    var wrapper = mount( /*#__PURE__*/React.createElement(Tooltip, {
      triggerText: "Tooltip"
    }, /*#__PURE__*/React.createElement("p", {
      className: "".concat(prefix, "--tooltip__label")
    }, "Tooltip label"), /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor sit amet")));
    var trigger = wrapper.find(".".concat(prefix, "--tooltip__trigger"));
    describe('tooltip trigger', function () {
      it('renders a tooltip container', function () {
        expect(trigger.length).toEqual(1);
      });
      it('renders the info icon', function () {
        var icon = trigger.find(Information);
        expect(icon.length).toBe(1);
      });
    });
  });
  describe('Renders as expected with specified properties', function () {
    var wrapper = mount( /*#__PURE__*/React.createElement(Tooltip, {
      className: "tooltip--class",
      triggerClassName: "tooltip--trigger-class",
      triggerText: "Tooltip",
      direction: "bottom",
      menuOffset: {
        left: 10,
        top: 15
      },
      showIcon: false,
      open: true
    }, /*#__PURE__*/React.createElement("p", null, "Tooltip label"), /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor sit amet")));
    var label = wrapper.find(".".concat(prefix, "--tooltip__label"));
    var floatingMenu = wrapper.find(FloatingMenu);
    describe('tooltip container', function () {
      it("sets the tooltip's position", function () {
        expect(floatingMenu.prop('menuDirection')).toEqual('bottom');
      });
      it("sets the tooltip's offset", function () {
        expect(floatingMenu.prop('menuOffset')).toEqual({
          left: 10,
          top: 15
        });
      });
      it('does not render info icon', function () {
        var icon = label.find(Information);
        expect(icon.exists()).toBe(false);
      });
      it('sets the tooltip class', function () {
        expect(floatingMenu.find('[data-floating-menu-direction]').first().prop('className')).toBe("".concat(prefix, "--tooltip ").concat(prefix, "--tooltip--shown ").concat(prefix, "--tooltip--bottom ").concat(prefix, "--tooltip--align-center tooltip--class"));
      });
      it('sets the trigger class', function () {
        expect(label.prop('className')).toBe("".concat(prefix, "--tooltip__label tooltip--trigger-class"));
      });
    });
  });
  describe('Renders as expected when an Icon component wrapped with forwardRef is provided', function () {
    var wrapper = mount( /*#__PURE__*/React.createElement(Tooltip, {
      renderIcon: Add
    }));
    it('does render Icon', function () {
      var icon = wrapper.find(Add);
      expect(icon.exists()).toBe(true);
    });
  });
  describe('Renders as expected when custom icon component with forwardRef is provided', function () {
    var wrapper = mount( /*#__PURE__*/React.createElement(Tooltip, {
      renderIcon: /*#__PURE__*/React.forwardRef(function () {
        return /*#__PURE__*/React.createElement(CustomIcon, null);
      })
    }));
    it('does render provided custom icon component instance', function () {
      var icon = wrapper.find(CustomIcon);
      expect(icon.exists()).toBe(true);
    });
  });
  describe('Renders as expected when custom icon component with inner forwardRef is provided', function () {
    var wrapper = mount( /*#__PURE__*/React.createElement(Tooltip, {
      renderIcon: OverflowMenuVertical16
    }));
    it('does render provided custom icon component instance', function () {
      var icon = wrapper.find(OverflowMenuVertical16);
      expect(icon.exists()).toBe(true);
    });
  });
  describe('events', function () {
    it('A different key press does not change state', function () {
      var wrapper = mount( /*#__PURE__*/React.createElement(Tooltip, {
        triggerText: "Tooltip"
      }));
      var icon = wrapper.find(Information);
      icon.simulate('keyDown', {
        which: 'x'
      }); // Enzyme doesn't seem to allow state() in a forwardRef-wrapped class component

      expect(wrapper.find('Tooltip').instance().state.open).toBeFalsy();
    });
    it('A different key press does not change state when custom icon is set', function () {
      var wrapper = mount( /*#__PURE__*/React.createElement(Tooltip, {
        renderIcon: /*#__PURE__*/React.forwardRef(function (props, ref) {
          return /*#__PURE__*/React.createElement("div", {
            className: "custom-icon",
            ref: ref
          });
        }),
        triggerText: "Tooltip"
      }));
      var icon = wrapper.find('.custom-icon');
      icon.simulate('keyDown', {
        which: 'x'
      }); // Enzyme doesn't seem to allow state() in a forwardRef-wrapped class component

      expect(wrapper.find('Tooltip').instance().state.open).toBeFalsy();
    });
    it('should be in a closed state after handleOutsideClick() is invoked', function () {
      var rootWrapper = mount( /*#__PURE__*/React.createElement(Tooltip, {
        triggerText: "Tooltip"
      })); // Enzyme doesn't seem to allow state() in a forwardRef-wrapped class component

      expect(rootWrapper.find('Tooltip').instance().state.open).toBeFalsy(); // Enzyme doesn't seem to allow setState() in a forwardRef-wrapped class component

      rootWrapper.find('Tooltip').instance().setState({
        open: true
      });
      rootWrapper.update();
      rootWrapper.find('Tooltip').instance().handleClickOutside(); // Enzyme doesn't seem to allow state() in a forwardRef-wrapped class component

      expect(rootWrapper.find('Tooltip').instance().state.open).toEqual(false);
    });
    it('prop.open change should update open state', function () {
      var rootWrapper = mount( /*#__PURE__*/React.createElement(Tooltip, {
        open: false,
        triggerText: "Tooltip"
      })); // Enzyme doesn't seem to allow state() in a forwardRef-wrapped class component

      expect(rootWrapper.find('Tooltip').instance().state.open).toEqual(false);
      rootWrapper.setProps({
        open: true,
        triggerText: 'Tooltip'
      }); // Enzyme doesn't seem to allow state() in a forwardRef-wrapped class component

      expect(rootWrapper.find('Tooltip').instance().state.open).toEqual(true);
    });
    it('should avoid change the open state upon setting props, unless there the value actually changes', function () {
      var rootWrapper = mount( /*#__PURE__*/React.createElement(Tooltip, null));
      rootWrapper.setProps({
        open: true
      }); // Enzyme doesn't seem to allow setState() in a forwardRef-wrapped class component

      rootWrapper.find('Tooltip').instance().setState({
        open: false
      });
      rootWrapper.update();
      rootWrapper.setProps({
        open: true
      }); // Enzyme doesn't seem to allow state() in a forwardRef-wrapped class component

      expect(rootWrapper.find('Tooltip').instance().state.open).toEqual(false);
    });
    it('escape key keyDown should not bubble outside the tooltip', function () {
      var onKeyDown = jest.fn();
      render( /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("div", {
        onKeyDown: onKeyDown
      }, /*#__PURE__*/React.createElement(Tooltip, {
        triggerText: "Tooltip"
      }))));
      userEvent.click(screen.getAllByRole('button')[0]);
      userEvent.keyboard('{esc}');
      expect(onKeyDown).not.toHaveBeenCalled();
    });
    it('should close the tooltip when escape key is pressed', function () {
      render( /*#__PURE__*/React.createElement(Tooltip, {
        triggerText: "trigger text",
        tooltipBodyId: "tooltip-body"
      }, /*#__PURE__*/React.createElement("p", {
        id: "tooltip-body"
      }, "tooltip body")));
      expect(screen.queryByText('trigger text')).toBeInTheDocument();
      expect(screen.queryByText('tooltip body')).not.toBeInTheDocument();
      var triggerButton = screen.getByRole('button');
      userEvent.click(triggerButton); // I am unsure why, but the trigger must be clicked a second time for the tooltip body to appear

      userEvent.click(triggerButton);
      expect(screen.queryByText('tooltip body')).toBeInTheDocument();
      userEvent.keyboard('{esc}');
      expect(screen.queryByText('tooltip body')).not.toBeInTheDocument();
    });
  });
});