/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import './story.scss';
import { Checkbox16 } from '@carbon/icons-react';
import React from 'react';
import { Tooltip } from '../next';
export default {
  title: 'Experimental/unstable_Tooltip',
  component: Tooltip,
  parameters: {
    controls: {
      hideNoControlsWarning: true
    },
    layout: 'centered'
  },
  argTypes: {
    children: {
      table: {
        disable: true
      }
    },
    className: {
      table: {
        disable: true
      }
    }
  }
};
export var Default = function Default() {
  var label = 'Occassionally, services are updated in a specified time window to ensure no down time for customers.';
  return /*#__PURE__*/React.createElement(Tooltip, {
    align: "bottom",
    defaultOpen: true,
    label: label
  }, /*#__PURE__*/React.createElement("button", {
    className: "demo-tooltip-trigger",
    type: "button"
  }, /*#__PURE__*/React.createElement(Checkbox16, null)));
};
export var Duration = function Duration() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Tooltip, {
    label: "Label one",
    enterDelayMs: 500,
    leaveDelayMs: 500
  }, /*#__PURE__*/React.createElement("button", {
    className: "demo-tooltip-trigger",
    type: "button"
  }, /*#__PURE__*/React.createElement(Checkbox16, null))), /*#__PURE__*/React.createElement(Tooltip, {
    label: "Label two",
    enterDelayMs: 500,
    leaveDelayMs: 500
  }, /*#__PURE__*/React.createElement("button", {
    className: "demo-tooltip-trigger",
    type: "button"
  }, /*#__PURE__*/React.createElement(Checkbox16, null))), /*#__PURE__*/React.createElement(Tooltip, {
    label: "Label three",
    enterDelayMs: 500,
    leaveDelayMs: 500
  }, /*#__PURE__*/React.createElement("button", {
    className: "demo-tooltip-trigger",
    type: "button"
  }, /*#__PURE__*/React.createElement(Checkbox16, null))));
};

var PlaygroundStory = function PlaygroundStory(props) {
  var align = props.align,
      defaultOpen = props.defaultOpen,
      description = props.description,
      enterDelayMs = props.enterDelayMs,
      label = props.label,
      leaveDelayMs = props.leaveDelayMs;
  return /*#__PURE__*/React.createElement(Tooltip, {
    align: align,
    defaultOpen: defaultOpen,
    description: description,
    enterDelayMs: enterDelayMs,
    label: label,
    leaveDelayMs: leaveDelayMs
  }, /*#__PURE__*/React.createElement("button", {
    className: "demo-tooltip-trigger",
    type: "button"
  }, /*#__PURE__*/React.createElement(Checkbox16, null)));
};

export var Playground = PlaygroundStory.bind({});
Playground.argTypes = {
  align: {
    defaultValue: 'bottom',
    options: ['top', 'top-left', 'top-right', 'bottom', 'bottom-left', 'bottom-right', 'left', 'left-bottom', 'left-top', 'right', 'right-bottom', 'right-top'],
    control: {
      type: 'select'
    }
  },
  defaultOpen: {
    defaultValue: true
  },
  label: {
    control: {
      type: 'text'
    },
    defaultValue: 'Custom label'
  },
  description: {
    control: {
      type: 'text'
    }
  }
};