import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["aria-label", "aria-labelledby", "className", "renderMenuIcon", "renderCloseIcon", "onClick", "isActive", "isCollapsible"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { Close20, Menu20 } from '@carbon/icons-react';
import cx from 'classnames';
import React from 'react';
import PropTypes from 'prop-types';
import { AriaLabelPropType } from '../../prop-types/AriaPropTypes';
import { usePrefix } from '../../internal/usePrefix';

var HeaderMenuButton = function HeaderMenuButton(_ref) {
  var _cx;

  var ariaLabel = _ref['aria-label'],
      ariaLabelledBy = _ref['aria-labelledby'],
      customClassName = _ref.className,
      renderMenuIcon = _ref.renderMenuIcon,
      renderCloseIcon = _ref.renderCloseIcon,
      onClick = _ref.onClick,
      isActive = _ref.isActive,
      isCollapsible = _ref.isCollapsible,
      rest = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  var className = cx((_cx = {}, _defineProperty(_cx, customClassName, !!customClassName), _defineProperty(_cx, "".concat(prefix, "--header__action"), true), _defineProperty(_cx, "".concat(prefix, "--header__menu-trigger"), true), _defineProperty(_cx, "".concat(prefix, "--header__action--active"), isActive), _defineProperty(_cx, "".concat(prefix, "--header__menu-toggle"), true), _defineProperty(_cx, "".concat(prefix, "--header__menu-toggle__hidden"), !isCollapsible), _cx));
  var accessibilityLabel = {
    'aria-label': ariaLabel,
    'aria-labelledby': ariaLabelledBy
  };
  var menuIcon = renderMenuIcon ? renderMenuIcon : /*#__PURE__*/React.createElement(Menu20, null);
  var closeIcon = renderCloseIcon ? renderCloseIcon : /*#__PURE__*/React.createElement(Close20, null);
  return /*#__PURE__*/React.createElement("button", _extends({}, rest, accessibilityLabel, {
    className: className,
    title: ariaLabel,
    type: "button",
    onClick: onClick
  }), isActive ? closeIcon : menuIcon);
};

HeaderMenuButton.propTypes = _objectSpread(_objectSpread({}, AriaLabelPropType), {}, {
  /**
   * Optionally provide a custom class name that is applied to the underlying
   * button
   */
  className: PropTypes.string,
  isActive: PropTypes.bool,

  /**
   * Optionally provide an onClick handler that is called when the underlying
   * button fires it's onclick event
   */
  onClick: PropTypes.func
});
export default HeaderMenuButton;