import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["expanded", "defaultExpanded", "isChildOfHeader", "aria-label", "aria-labelledby", "children", "onToggle", "className", "isFixedNav", "isRail", "isPersistent", "addFocusListeners", "addMouseListeners", "onOverlayClick"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useState, useRef } from 'react';
import cx from 'classnames';
import PropTypes from 'prop-types';
import { AriaLabelPropType } from '../../prop-types/AriaPropTypes';
import { CARBON_SIDENAV_ITEMS } from './_utils';
import { usePrefix } from '../../internal/usePrefix'; // TO-DO: comment back in when footer is added for rails
// import SideNavFooter from './SideNavFooter';

var SideNav = /*#__PURE__*/React.forwardRef(function SideNav(props, ref) {
  var _cx, _cx2;

  var expandedProp = props.expanded,
      defaultExpanded = props.defaultExpanded,
      isChildOfHeader = props.isChildOfHeader,
      ariaLabel = props['aria-label'],
      ariaLabelledBy = props['aria-labelledby'],
      children = props.children,
      onToggle = props.onToggle,
      customClassName = props.className,
      isFixedNav = props.isFixedNav,
      isRail = props.isRail,
      isPersistent = props.isPersistent,
      addFocusListeners = props.addFocusListeners,
      addMouseListeners = props.addMouseListeners,
      onOverlayClick = props.onOverlayClick,
      other = _objectWithoutProperties(props, _excluded);

  var prefix = usePrefix();

  var _useRef = useRef(expandedProp !== undefined),
      controlled = _useRef.current;

  var _useState = useState(defaultExpanded),
      _useState2 = _slicedToArray(_useState, 2),
      expandedState = _useState2[0],
      setExpandedState = _useState2[1];

  var _useState3 = useState(defaultExpanded),
      _useState4 = _slicedToArray(_useState3, 2),
      expandedViaHoverState = _useState4[0],
      setExpandedViaHoverState = _useState4[1];

  var expanded = controlled ? expandedProp : expandedState;

  var handleToggle = function handleToggle(event) {
    var value = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : !expanded;

    if (!controlled) {
      setExpandedState(value);
    }

    if (onToggle) {
      onToggle(event, value);
    }

    if (controlled || isRail) {
      setExpandedViaHoverState(value);
    }
  };

  var accessibilityLabel = {
    'aria-label': ariaLabel,
    'aria-labelledby': ariaLabelledBy
  }; // TO-DO: comment back in when footer is added for rails
  // const assistiveText = expanded
  //   ? t('carbon.sidenav.state.open')
  //   : t('carbon.sidenav.state.closed');

  var className = cx((_cx = {}, _defineProperty(_cx, "".concat(prefix, "--side-nav"), true), _defineProperty(_cx, "".concat(prefix, "--side-nav--expanded"), expanded || expandedViaHoverState), _defineProperty(_cx, "".concat(prefix, "--side-nav--collapsed"), !expanded && isFixedNav), _defineProperty(_cx, "".concat(prefix, "--side-nav--rail"), isRail), _defineProperty(_cx, customClassName, !!customClassName), _defineProperty(_cx, "".concat(prefix, "--side-nav--ux"), isChildOfHeader), _defineProperty(_cx, "".concat(prefix, "--side-nav--hidden"), !isPersistent), _cx));
  var overlayClassName = cx((_cx2 = {}, _defineProperty(_cx2, "".concat(prefix, "--side-nav__overlay"), true), _defineProperty(_cx2, "".concat(prefix, "--side-nav__overlay-active"), expanded || expandedViaHoverState), _cx2));
  var childrenToRender = children; // if a rail, pass the expansion state as a prop, so children can update themselves to match

  if (isRail) {
    childrenToRender = React.Children.map(children, function (child) {
      var _child$type$displayNa, _child$type, _child$type2;

      // if we are controlled, check for if we have hovered over or the expanded state, else just use the expanded state (uncontrolled)
      var currentExpansionState = controlled ? expandedViaHoverState || expanded : expanded; // avoid spreading `isSideNavExpanded` to non-Carbon UI Shell children

      return /*#__PURE__*/React.cloneElement(child, _objectSpread({}, CARBON_SIDENAV_ITEMS.includes((_child$type$displayNa = (_child$type = child.type) === null || _child$type === void 0 ? void 0 : _child$type.displayName) !== null && _child$type$displayNa !== void 0 ? _child$type$displayNa : (_child$type2 = child.type) === null || _child$type2 === void 0 ? void 0 : _child$type2.name) ? {
        isSideNavExpanded: currentExpansionState
      } : {}));
    });
  }

  var eventHandlers = {};

  if (addFocusListeners) {
    eventHandlers.onFocus = function (event) {
      if (!event.currentTarget.contains(event.relatedTarget)) {
        handleToggle(event, true);
      }
    };

    eventHandlers.onBlur = function (event) {
      if (!event.currentTarget.contains(event.relatedTarget)) {
        handleToggle(event, false);
      }
    };
  }

  if (addMouseListeners && isRail) {
    eventHandlers.onMouseEnter = function () {
      return handleToggle(true, true);
    };

    eventHandlers.onMouseLeave = function () {
      return handleToggle(false, false);
    };
  }

  return /*#__PURE__*/React.createElement(React.Fragment, null, isFixedNav ? null :
  /*#__PURE__*/
  // eslint-disable-next-line jsx-a11y/click-events-have-key-events, jsx-a11y/no-static-element-interactions
  React.createElement("div", {
    className: overlayClassName,
    onClick: onOverlayClick
  }), /*#__PURE__*/React.createElement("nav", _extends({
    "aria-hidden": !expanded,
    ref: ref,
    className: "".concat(prefix, "--side-nav__navigation ").concat(className)
  }, accessibilityLabel, eventHandlers, other), childrenToRender));
});
SideNav.displayName = 'SideNav';
SideNav.defaultProps = {
  // TO-DO: comment back in when footer is added for rails
  // translateById: (id) => {
  //   const translations = {
  //     'carbon.sidenav.state.open': 'Close',
  //     'carbon.sidenav.state.closed': 'Open',
  //   };
  //   return translations[id];
  // },
  defaultExpanded: false,
  isChildOfHeader: true,
  isFixedNav: false,
  isPersistent: true,
  addFocusListeners: true,
  addMouseListeners: true
};
SideNav.propTypes = _objectSpread(_objectSpread({}, AriaLabelPropType), {}, {
  /**
   * Specify whether focus and blur listeners are added. They are by default.
   */
  addFocusListeners: PropTypes.bool,

  /**
   * Specify whether mouse entry/exit listeners are added. They are by default.
   */
  addMouseListeners: PropTypes.bool,

  /**
   * Optionally provide a custom class to apply to the underlying `<li>` node
   */
  className: PropTypes.string,

  /**
   * If `true`, the SideNav will be open on initial render.
   */
  defaultExpanded: PropTypes.bool,

  /**
   * If `true`, the SideNav will be expanded, otherwise it will be collapsed.
   * Using this prop causes SideNav to become a controled component.
   */
  expanded: PropTypes.bool,

  /**
   * Optionally provide a custom class to apply to the underlying `<li>` node
   */
  isChildOfHeader: PropTypes.bool,

  /**
   * Specify if sideNav is standalone
   */
  isFixedNav: PropTypes.bool,

  /**
   * Specify if the sideNav will be persistent above the lg breakpoint
   */
  isPersistent: PropTypes.bool,

  /**
   * Optional prop to display the side nav rail.
   */
  isRail: PropTypes.bool,

  /**
   * An optional listener that is called when the SideNav overlay is clicked
   *
   * @param {object} event
   */
  onOverlayClick: PropTypes.func,

  /**
   * An optional listener that is called when an event that would cause
   * toggling the SideNav occurs.
   *
   * @param {object} event
   * @param {boolean} value
   */
  onToggle: PropTypes.func,

  /**
   * Provide a custom function for translating all message ids within this
   * component. This function will take in two arguments: the mesasge Id and the
   * state of the component. From this, you should return a string representing
   * the label you want displayed or read by screen readers.
   */
  translateById: PropTypes.func
});
export default SideNav;