import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "isActive"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import cx from 'classnames';
import PropTypes from 'prop-types';
import React from 'react';
import SideNavLinkText from './SideNavLinkText';
import Link from './Link';
import { usePrefix } from '../../internal/usePrefix';
var SideNavMenuItem = /*#__PURE__*/React.forwardRef(function SideNavMenuItem(props, ref) {
  var _cx;

  var prefix = usePrefix();

  var children = props.children,
      customClassName = props.className,
      isActive = props.isActive,
      rest = _objectWithoutProperties(props, _excluded);

  var className = cx("".concat(prefix, "--side-nav__menu-item"), customClassName);
  var linkClassName = cx((_cx = {}, _defineProperty(_cx, "".concat(prefix, "--side-nav__link"), true), _defineProperty(_cx, "".concat(prefix, "--side-nav__link--current"), isActive), _cx));
  return /*#__PURE__*/React.createElement("li", {
    className: className
  }, /*#__PURE__*/React.createElement(Link, _extends({}, rest, {
    className: linkClassName,
    ref: ref
  }), /*#__PURE__*/React.createElement(SideNavLinkText, null, children)));
});
SideNavMenuItem.displayName = 'SideNavMenuItem';
SideNavMenuItem.propTypes = {
  /**
   * Specify the children to be rendered inside of the `SideNavMenuItem`
   */
  children: PropTypes.node,

  /**
   * Provide an optional class to be applied to the containing node
   */
  className: PropTypes.string,

  /**
   * Optionally specify whether the link is "active". An active link is one that
   * has an href that is the same as the current page. Can also pass in
   * `aria-current="page"`, as well.
   */
  isActive: PropTypes.bool
};
export default SideNavMenuItem;