import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import cx from 'classnames';
import PropTypes from 'prop-types';
import { usePrefix } from '../../internal/usePrefix';

var SwitcherDivider = function SwitcherDivider(_ref) {
  var customClassName = _ref.className,
      other = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  var className = cx("".concat(prefix, "--switcher__item--divider"), _defineProperty({}, customClassName, !!customClassName));
  return /*#__PURE__*/React.createElement("hr", _extends({}, other, {
    className: className
  }));
};

SwitcherDivider.propTypes = {
  /**
   * Optionally provide a custom class to apply to the underlying `<li>` node
   */
  className: PropTypes.string
};
export default SwitcherDivider;