import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["aria-label", "aria-labelledby", "children", "className"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import cx from 'classnames';
import React from 'react';
import PropTypes from 'prop-types';
import { AriaLabelPropType } from '../../../prop-types/AriaPropTypes';
import { usePrefix } from '../../../internal/usePrefix';

function HeaderNavigation(props) {
  var ariaLabel = props['aria-label'],
      ariaLabelledBy = props['aria-labelledby'],
      children = props.children,
      customClassName = props.className,
      rest = _objectWithoutProperties(props, _excluded);

  var prefix = usePrefix();
  var className = cx("".concat(prefix, "--header__nav"), customClassName); // Assign both label strategies in this option, only one should be defined
  // so when we spread that should be the one that is applied to the node

  var accessibilityLabel = {
    'aria-label': ariaLabel,
    'aria-labelledby': ariaLabelledBy
  };
  return /*#__PURE__*/React.createElement("nav", _extends({}, rest, accessibilityLabel, {
    className: className
  }), /*#__PURE__*/React.createElement("ul", {
    className: "".concat(prefix, "--header__menu-bar")
  }, children));
}

HeaderNavigation.propTypes = _objectSpread(_objectSpread({}, AriaLabelPropType), {}, {
  /**
   * Provide valid children of HeaderNavigation, for example `HeaderMenuItem`
   * or `HeaderMenu`
   */
  children: PropTypes.node,

  /**
   * Optionally provide a custom class to apply to the underlying <nav> node
   */
  className: PropTypes.string
});
export { HeaderNavigation };