/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import ListItem from '../ListItem';
import UnorderedList from '../UnorderedList';
import { withKnobs, boolean } from '@storybook/addon-knobs';
import mdx from './UnorderedList.mdx';
var props = {
  regular: function regular() {
    return {
      isExpressive: boolean('Expressive', false)
    };
  }
};
export default {
  title: 'Components/UnorderedList',
  decorators: [withKnobs],
  parameters: {
    component: UnorderedList,
    docs: {
      page: mdx
    },
    subcomponents: {
      ListItem: ListItem
    }
  }
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(UnorderedList, null, /*#__PURE__*/React.createElement(ListItem, null, "Unordered List level 1"), /*#__PURE__*/React.createElement(ListItem, null, "Unordered List level 1"), /*#__PURE__*/React.createElement(ListItem, null, "Unordered List level 1"));
};
Default.storyName = 'default';
Default.parameters = {
  info: {
    text: 'Lists consist of related content grouped together and organized ' + 'vertically. Unordered lists are used to present content of equal ' + 'status or value.'
  }
};
export var Nested = function Nested() {
  var regularProps = props.regular();
  return /*#__PURE__*/React.createElement(UnorderedList, regularProps, /*#__PURE__*/React.createElement(ListItem, null, "Unordered List level 1", /*#__PURE__*/React.createElement(UnorderedList, {
    nested: true
  }, /*#__PURE__*/React.createElement(ListItem, null, "Unordered List level 2"), /*#__PURE__*/React.createElement(ListItem, null, "Unordered List level 2", /*#__PURE__*/React.createElement(UnorderedList, {
    nested: true
  }, /*#__PURE__*/React.createElement(ListItem, null, "Unordered List level 2"), /*#__PURE__*/React.createElement(ListItem, null, "Unordered List level 2"))))), /*#__PURE__*/React.createElement(ListItem, null, "Unordered List level 1"), /*#__PURE__*/React.createElement(ListItem, null, "Unordered List level 1"));
};
Nested.storyName = 'nested';
Nested.parameters = {
  info: {
    text: 'Lists consist of related content grouped together and organized ' + 'vertically. Unordered lists are used to present content of equal ' + 'status or value.'
  }
};