import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "nested", "isExpressive"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import classnames from 'classnames';
import { usePrefix } from '../../internal/usePrefix';

var UnorderedList = function UnorderedList(_ref) {
  var _classnames;

  var children = _ref.children,
      className = _ref.className,
      nested = _ref.nested,
      isExpressive = _ref.isExpressive,
      other = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  var classNames = classnames("".concat(prefix, "--list--unordered"), className, (_classnames = {}, _defineProperty(_classnames, "".concat(prefix, "--list--nested"), nested), _defineProperty(_classnames, "".concat(prefix, "--list--expressive"), isExpressive), _classnames));
  return /*#__PURE__*/React.createElement("ul", _extends({
    className: classNames
  }, other), children);
};

UnorderedList.propTypes = {
  /**
   * Specify a collection of ListItem's to be rendered in the UnorderedList
   */
  children: PropTypes.node,

  /**
   * Specify an optional className to be applied to the underlying `<ul>` node
   */
  className: PropTypes.string,

  /**
   * Specify whether this ordered list expressive or not
   */
  isExpressive: PropTypes.bool,

  /**
   * Specify whether the list is nested, or not
   */
  nested: PropTypes.bool
};
UnorderedList.defaultProps = {
  nested: false,
  isExpressive: false
};
export default UnorderedList;